;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Ieee/control.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 17:48:44 1995                          */
;*    Last change :  Thu Jul 13 15:03:34 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.9. Control features (page 27, r4)                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_control_features_6_9

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (macro bool c-procedure?  (obj)       "PROCEDUREP")
	    (obj call-cc              (procedure) "call_cc"))

   (export  (inline procedure?::bool    ::obj)
	    (apply                      ::procedure obj1 . args)
	    (map::obj                   ::procedure . pair)
	    (map-2::obj                 ::procedure ::obj)
	    (for-each                   ::procedure . pair)
	    (for-each-2                 ::procedure ::obj)
	    (inline force               promise)
	    (make-promise               ::procedure)
	    (inline call/cc             ::procedure))
   
   (pragma  (c-procedure? (_type-checker_ procedure))))

;*---------------------------------------------------------------------*/
;*    procedure? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (procedure? obj)
   (c-procedure? obj))

;*---------------------------------------------------------------------*/
;*    apply ...                                                        */
;*---------------------------------------------------------------------*/
(define (apply proc args . opt)
   (let ((args (if (pair? opt)
		   (cons args (let loop ((opt opt))
				 (if (pair? (cdr opt))
				     (cons (car opt) (loop (cdr opt)))
				     (car opt))))
		   args)))
      (apply proc args)))

;*---------------------------------------------------------------------*/
;*    map-2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (map-2 f l)
   (let loop ((l l))
      (if (null? l)
	  '()
	  (cons (f (car l)) (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    map ...                                                          */
;*---------------------------------------------------------------------*/
(define (map f . l)
   (cond
      ((null? l)
       '())
      ((null? (cdr l))
       (map-2 f (car l)))
      (else
       (let loop ((l l))
	  (if (null? (car l))
	      '()
	      (cons (apply f (map-2 car l))
		    (loop (map-2 cdr l))))))))

;*---------------------------------------------------------------------*/
;*    for-each-2 ...                                                   */
;*---------------------------------------------------------------------*/
(define (for-each-2 f l)
   (let loop ((l l))
      (if (null? l)
	  '()
	  (begin
	     (f (car l))
	     (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    for-each ...                                                     */
;*---------------------------------------------------------------------*/
(define (for-each f . l)
   (cond
      ((null? l)
       '())
      ((null? (cdr l))
       (for-each-2 f (car l)))
      (else
       (let loop ((l l))
	  (if (null? (car l))
	      '()
	      (begin
		 (apply f (map car l))
		 (loop (map cdr l))))))))

;*---------------------------------------------------------------------*/
;*    force ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (force promise)
   (promise))

;*---------------------------------------------------------------------*/
;*    make-promise ...                                                 */
;*---------------------------------------------------------------------*/
(define (make-promise proc)
   (let ((result-ready? #f)
	 (result        #f))
      (lambda ()
	 (if result-ready?
	     result
	     (let ((x (proc)))
		(if result-ready?
		    result
		    (begin
		       (set! result-ready? #t)
		       (set! result x)
		       result))))))) 

;*---------------------------------------------------------------------*/
;*    call/cc ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (call/cc proc)
   (call-cc proc))

