;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Ieee/string.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 20 19:17:18 1995                          */
;*    Last change :  Tue Oct  3 11:31:34 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.7. Strings (page 25, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_strings_6_7

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (macro bool c-string?       (obj)              "STRINGP")
	    (bstring    c-make-string   (long uchar)       "make_string")
	    
	    (macro long c-string-length (bstring)          "STRING_LENGTH")
	    
	    (macro uchar c-string-ref  (bstring long)      "STRING_REF")
	    (macro obj  c-string-set! (bstring long uchar) "STRING_SET")
	    
	    (bool    c-string=?  (bstring bstring)     "bigloo_strcmp")
	    (bool    strcicmp    (bstring bstring)     "strcicmp")
	    (bool    string_lt   (bstring bstring)     "string_lt")
	    (bool    string_le   (bstring bstring)     "string_le")
	    (bool    string_gt   (bstring bstring)     "string_gt")
	    (bool    string_ge   (bstring bstring)     "string_ge")
	    (bool    string_cilt (bstring bstring)     "string_cilt")
	    (bool    string_cile (bstring bstring)     "string_cile")
	    (bool    string_cigt (bstring bstring)     "string_cigt")
	    (bool    string_cige (bstring bstring)     "string_cige")
	    
	    (bstring c-string-copy (string)            "string_to_bstring")
	    (bstring c-substring (bstring long long)   "c_substring")
	    (bstring c-string-append (bstring bstring) "string_append")
	    
	    (bstring escape-C-string (string)          "escape_C_string")
	    (bstring escape-scheme-string (string)     "escape_scheme_string")
	    (bstring c-constant-string-to-string (string)
 			    "c_constant_string_to_string")
	    
	    (macro bool string-bound-check? (long long) "BOUND_CHECK")
	    (bstring c-string-for-read (bstring)        "string_for_read")
	    (obj   c-blit-string (bstring bint bstring bint bint)
		   "blit_string"))
   
   (export  (inline string?::bool               ::obj)
	    (inline make-string::bstring        ::int . char)
	    (inline string::bstring             . chars)
	    (inline string-length::long         ::bstring)
	    (inline string-ref::uchar           ::bstring ::long)
	    (inline string-set!::obj            ::bstring ::long ::uchar)
	    (inline string-ref-ur::uchar        ::bstring ::long)
	    (inline string-set-ur!::obj         ::bstring ::long ::uchar)
	    (inline string=?::bool              ::bstring ::bstring)
	    (inline string-ci=?::bool           ::bstring ::bstring)
	    (inline string<?::bool              ::bstring ::bstring)
	    (inline string>?::bool              ::bstring ::bstring)
	    (inline string<=?::bool             ::bstring ::bstring)
	    (inline string>=?::bool             ::bstring ::bstring)
	    (inline string-ci<?::bool           ::bstring ::bstring)
	    (inline string-ci>?::bool           ::bstring ::bstring)
	    (inline string-ci<=?::bool          ::bstring ::bstring)
	    (inline string-ci>=?::bool          ::bstring ::bstring)
	    (inline substring::bstring          ::bstring ::long ::long)
	    (inline substring-ur::bstring       ::bstring ::long ::long)
	    (string-append::bstring             . strings)
	    (string->list                       ::bstring)
	    (list->string::bstring              ::obj)
	    (inline string-copy::bstring        ::bstring)
	    (string-fill!::bstring              ::bstring ::uchar)
	    (string-upcase::bstring             ::bstring)
	    (string-downcase::bstring           ::bstring)
	    (string-upcase!::bstring            ::bstring)
	    (string-downcase!::bstring          ::bstring)
	    (inline string-for-read::bstring    ::bstring)
	    (inline blit-string-ur!             ::bstring ::bint
		                                ::bstring ::bint
					        ::bint)
	    (blit-string!                       ::bstring ::bint
		                                ::bstring ::bint
					        ::bint))
   
   (pragma  (c-string? _no_side_effect_ (_type-checker_ bstring))
	    (string? _no_side_effect_)
	    (c-string-ref _no_side_effect_)
	    (string-ref-ur _no_side_effect_)
	    (c-string-length _no_side_effect_)
	    (string-bound-check? _no_side_effect_)))
 
;*---------------------------------------------------------------------*/
;*    string? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (string? obj)
   (c-string? obj))

;*---------------------------------------------------------------------*/
;*    make-string ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (make-string k . char)
   (if (null? char)
       (c-make-string k #\space)
       (c-make-string k (car char))))
 
;*---------------------------------------------------------------------*/
;*    string ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (string . chars)
   (list->string chars))

;*---------------------------------------------------------------------*/
;*    string-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (string-length string)
   (c-string-length string))

;*---------------------------------------------------------------------*/
;*    string-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (string-ref string k)
   (if (string-bound-check? k (string-length string))
       (c-string-ref string k)
       (error "string-ref" "index out of range" k)))
 
;*---------------------------------------------------------------------*/
;*    string-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-set! string k char)
   (if (string-bound-check? k (string-length string))
       (c-string-set! string k char)
       (error "string-set!" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    string-ref-ur ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (string-ref-ur string k)
   (c-string-ref string k))
 
;*---------------------------------------------------------------------*/
;*    string-set-ur! ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (string-set-ur! string k char)
   (c-string-set! string k char))

;*---------------------------------------------------------------------*/
;*    string=? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string=? string1 string2)
   (c-string=? string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci=? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci=? string1 string2)
   (strcicmp string1 string2))

;*---------------------------------------------------------------------*/
;*    string<? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string<? string1 string2)
   (string_lt string1 string2))

;*---------------------------------------------------------------------*/
;*    string>? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string>? string1 string2)
   (string_gt string1 string2))

;*---------------------------------------------------------------------*/
;*    string<=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (string<=? string1 string2)
   (string_le string1 string2))

;*---------------------------------------------------------------------*/
;*    string>=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (string>=? string1 string2)
   (string_ge string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci<? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci<? string1 string2)
   (string_cilt string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci>? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci>? string1 string2)
   (string_cigt string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci<=? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-ci<=? string1 string2)
   (string_cile string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci>=? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-ci>=? string1 string2)
   (string_cige string1 string2))

;*---------------------------------------------------------------------*/
;*    sustring ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (substring string start end)
   ;; no macro on inline so we don't use `and'
   (if (if (>=fx end start)
	   (if (string-bound-check? start (+fx (string-length string) 1))
	       (string-bound-check? end (+fx (string-length string) 1))
	       #f)
	   #f)
       (c-substring string start end)
       (error "substring" "Illegal index" (cons start end))))

;*---------------------------------------------------------------------*/
;*    sustring-ur ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (substring-ur string start end)
   (c-substring string start end))

;*---------------------------------------------------------------------*/
;*    string-append ...                                                */
;*---------------------------------------------------------------------*/
(define (string-append . list)
   (if (null? list)
       ""
       (let loop ((list list))
	  (if (null? (cdr list))
	      (car list)
	      (c-string-append (car list) (loop (cdr list)))))))

;*---------------------------------------------------------------------*/
;*    list->string ...                                                 */
;*---------------------------------------------------------------------*/
(define (list->string list)
   (let* ((len    (length list))
	  (string (make-string len)))
      (let loop ((i 0)
		 (l list))
	 (if (=fx i len)
	     string
	     (begin
		(string-set! string i (car l))
		(loop (+fx i 1) (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    string->list ...                                                 */
;*---------------------------------------------------------------------*/
(define (string->list string)
   (let ((len (string-length string)))
      (let loop ((i   0)
		 (acc '()))
	 (if (=fx i len)
	     (reverse! acc)
	     (loop (+fx i 1)
		   (cons (string-ref string i)
			 acc))))))

;*---------------------------------------------------------------------*/
;*    string-copy ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-copy string)
   (c-string-copy string))

;*---------------------------------------------------------------------*/
;*    string-fill! ...                                                 */
;*---------------------------------------------------------------------*/
(define (string-fill! string char)
   (let ((len (string-length string)))
      (let loop ((i 0))
	 (if (=fx i len)
	     string
	     (begin
		(string-set! string i char)
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-upcase ...                                                */
;*---------------------------------------------------------------------*/
(define (string-upcase string)
   (let* ((len (string-length string))
	  (res (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-upcase (string-ref string i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-downcase ...                                              */
;*---------------------------------------------------------------------*/
(define (string-downcase string)
   (let* ((len (string-length string))
	  (res (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-downcase (string-ref string i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-upcase! ...                                               */
;*---------------------------------------------------------------------*/
(define (string-upcase! string)
   (let* ((len (string-length string))
	  (res string))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-upcase (string-ref string i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-downcase! ...                                             */
;*---------------------------------------------------------------------*/
(define (string-downcase! string)
   (let* ((len (string-length string))
	  (res string))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-downcase (string-ref string i)))
		(loop (+fx i 1)))))))
		 		 
;*---------------------------------------------------------------------*/
;*    string-for-read ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (string-for-read string)
   (c-string-for-read string))

;*---------------------------------------------------------------------*/
;*    blit-string-ur! ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (blit-string-ur! s1 o1 s2 o2 l)
   (c-blit-string s1 o1 s2 o2 l))

;*---------------------------------------------------------------------*/
;*    blit-string! ...                                                 */
;*---------------------------------------------------------------------*/
(define (blit-string! s1 o1 s2 o2 l)
  (if (and (string-bound-check? (+fx l o1) (+fx (string-length s1) 1))
	   (string-bound-check? (+fx l o2) (+fx (string-length s2) 1)))
      (c-blit-string s1 o1 s2 o2 l)
      (error "blit-string" "Index and length out of range" 
	     (list (string-length s1) o1 (string-length s2) o2 l))))

