;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.8/Llib/struct.scm           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 30 13:02:29 1992                          */
;*    Last change :  Mon Jul 17 11:36:27 1995 (serrano)                */
;*                                                                     */
;*    Les structures (non r4)                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __structure

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
   	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro obj    c-struct-ref    (struct long)      "STRUCT_REF")
	    (macro obj    c-struct-set!   (struct long obj)  "STRUCT_SET")
	    (macro obj    u-struct-ref    (obj long)         "STRUCT_REF")
	    (macro obj    u-struct-set!   (obj long obj)     "STRUCT_SET")
	    (macro symbol c-struct-key    (struct)           "STRUCT_KEY")
	    (macro bool   c-struct?       (obj)              "STRUCTP")
	    (macro long   c-struct-length (struct)           "STRUCT_LENGTH")
	    (struct       c-make-struct   (symbol long obj)  "make_struct")
	    (struct       c-create-struct (symbol long)      "create_struct")
	    (macro obj    c-peek          (obj long)         "PEEK")
	    (macro obj    c-poke!         (obj long obj)     "POKE"))
   
   (export  (inline make-struct::struct    ::symbol ::long ::obj)
	    (inline struct?::bool          ::obj)
	    (inline struct-key::symbol     ::struct)
	    (inline struct-length::long    ::struct)
	    (inline struct-ref             ::struct ::long)
	    (inline struct-set!            ::struct ::long ::obj)
	    (struct-update!                ::struct ::struct)
	    (inline peek                   ::struct ::long)
	    (inline poke!                  ::struct ::long ::obj))

   (pragma  (c-struct? (_type-checker_ struct) _no_side_effect_)
	    (c-struct-length _no_side_effect_)
	    (c-struct-ref _no_side_effect_)
	    (u-struct-ref _no_side_effect_)
	    (c-struct-key _no_side_effect_)))
	    
;*---------------------------------------------------------------------*/
;*    make-struct ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (make-struct key len init)
   (c-make-struct key len init))

;*---------------------------------------------------------------------*/
;*    peek ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (peek struct offset)
   (c-peek struct offset))

;*---------------------------------------------------------------------*/
;*    poke! ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (poke! struct offset value)
   (c-poke! struct offset value))

;*---------------------------------------------------------------------*/
;*    struct? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline  (struct? o)
   (c-struct? o))

;*---------------------------------------------------------------------*/
;*    struct-key ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline  (struct-key s)
   (c-struct-key s))

;*---------------------------------------------------------------------*/
;*    struct-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline  (struct-length s)
   (c-struct-length s))
   
;*---------------------------------------------------------------------*/
;*    struct-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline  (struct-ref s k)
   (c-struct-ref s k))

;*---------------------------------------------------------------------*/
;*    struct-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (struct-set! s k o)
   (c-struct-set! s k o))

;*---------------------------------------------------------------------*/
;*    struct-update! ...                                               */
;*---------------------------------------------------------------------*/
(define (struct-update! dst src)
   (if (and (eq? (struct-key dst) (struct-key src))
	    (=fx (struct-length dst) (struct-length src)))
       (let loop ((i (-fx (struct-length dst) 1)))
	  (if (=fx i -1)
	      dst
	      (begin
		 (struct-set! dst i (struct-ref src i))
		 (loop (-fx i 1)))))
       (error "struct-update!" "Incompatible structures" (list dst src))))

 
