open Unix
open Document
open Feed
open Http_headers

(* Insert a decoding if necessary.
 * We don't do it in http, since we don't want do decompress when we
 * save for example.
 *)

let decoders = Hashtbl.create 37

let gzip dh =
  let (fd_in, fd_out) = pipe() in
  match Low.fork() with
    0 ->  close fd_in; 
      	  dup2 dh.document_feed.feed_internal stdin; dup2 fd_out stdout;
          Munix.execvp "gzcat" [| "gzcat" |];
          dh
  | n ->  
     close fd_out;
     (* it is safe to close feed because the son has a copy *)
      dh.document_feed.feed_close();
      { document_id = dh.document_id;
	document_referer = dh.document_referer;
        document_status = dh.document_status;
	document_headers = dh.document_headers;
	document_feed = Feed.of_fd fd_in;
	document_fragment = dh.document_fragment;
	document_logger = dh.document_logger }
  

let _ =  List.iter (fun (s,t) -> Hashtbl.add decoders s t)
  [ "COMPRESS", gzip;
    "X-COMPRESS", gzip;
    "GZIP", gzip;
    "X-GZIP", gzip]

let unsafe_add_decoding = Hashtbl.add decoders

let add dtype f = 
  try
    let _ = Hashtbl.find decoders dtype in
    if Error.default#choose 
      	 (I18n.sprintf "An applet attempts to replace the decoder \
      	       	       	associated with type %s" dtype)
    then begin
	Hashtbl.remove decoders dtype;
	unsafe_add_decoding dtype f
      end
  with
    Not_found -> unsafe_add_decoding dtype f

let insert dh =
(* CERN proxy sets Content-Encoding when return code = 500 ! *)
  if dh.document_status >= 400 then dh else
  try
    Hashtbl.find decoders
       (Mstring.uppercase (contentencoding dh.document_headers)) dh
  with
    Not_found -> dh
  | Unix_error(_,_,_) -> dh

