open Tk
open Unix
open Frx_text
open Document
open Viewers
open Feed

type twidget = {
  widget : Widget.widget;
  add_text : string -> unit;
  set_progress : int -> unit;
  redisplay : unit -> unit
 }

(* A lot of this is copied from htmlw *)

let headers_menu top v dh =
  let headers =
    Menubutton.create_named top "headers" [TextVariable v; TextWidth 80] in
  let headersm = Menu.create_named headers "menu" [] in
   Menubutton.configure headers [Menu headersm];
   List.iter 
    (function h ->
      	Menu.add_command headersm [Label h])
    (List.rev dh.document_headers);
  headers

(* Pseudo widget *)
let create top ctx dh =
  let did = dh.document_id		(* we use it often *)
  and pending = ref true		(* avoid some ops until finished *)
  in
  let vgroup = Frame.create top [] in
   (* The title of the document *)
   let titlev = Textvariable.create_temporary vgroup in
     Textvariable.set titlev (Url.string_of did.document_url);
   let headersb = headers_menu vgroup titlev dh in

  (* Progress report and pointsto *)
  let hgbas = Frame.create vgroup [] in
  let fprog, set_progress = Frx_fillbox.new_horizontal hgbas 200 5
  in
    pack [fprog][Side Side_Left];

  (* Scrollable text widget *)
  let hgroup = Frame.create_named vgroup "textw" [Class "Plain"]
  in
  let ftext, text = 
     Frx_text.new_scrollable_text hgroup [Wrap WrapWord; State Disabled] true 
  in
    (* Tk4.0pl3 fix, + avoid cb to scrollbar *)
    Text.configure text [TakeFocus true; InsertOffTime 0];
    Frx_text.addsearch text;
     (* IN THIS ORDER -- RESIZING *)
    pack [ftext][Side Side_Left; Fill Fill_Both; Expand true];
    (* IN THIS ORDER -- RESIZING *)
    pack [headersb][Fill Fill_X];
    pack [hgbas][Side Side_Bottom; Fill Fill_X];
    pack [hgroup][Fill Fill_Both; Expand true];

  let add_text s =
    if s = "" then pending := false else
    if Winfo.exists text then begin
     Text.configure text [State Normal];
     Text.insert text textEnd s [];
     Text.configure text [State Disabled]
    end
  and redisplay () = 
    if !pending then 
      Error.default#f (I18n.sprintf "Cannot redisplay document (pending)")
    else begin
      (* We need to get the buffer from the cache, if the document was
	 reloaded for example. *)
	try
	  match Cache.find did with
	    {document_data = FileData _} ->
	       Error.default#f 
		  (I18n.sprintf "Cannot redisplay document (on file)")
	  | {document_data = MemoryData buffer} -> 
            if Winfo.exists text then begin
	      set_progress 0;
	      Text.configure text [State Normal];
	      Text.delete text (TextIndex(LineChar(0,0), [])) textEnd;
	      Text.insert text textEnd (Ebuffer.get buffer) [];
	      Text.configure text [State Disabled];
	      set_progress 100
	   end
       with (* document is not cached anymore ??? *)
	 Not_found -> Error.default#f
                         (I18n.sprintf "Document not in cache anymore")
    end
  in
  { widget = vgroup;
    add_text = add_text;
    set_progress = set_progress;
    redisplay = redisplay }

(* Viewing text/plain *)
let display_plain mediapars top vcontext dh =
  let url = dh.document_id.document_url in

  if not (Winfo.exists top) then failwith "too late"
  else begin
    let hw = create top vcontext dh (* the widget *)
    and buffer = String.create 2048
    and red = ref 0
    and size = 
      try Http_headers.contentlength dh.document_headers
      with Not_found -> 40000 (* duh *) 
    in
    let abort = 
      let terminated = ref false in
      (fun () ->
	if not !terminated then begin
	    vcontext.viewer_log "";
	    dclose true dh;
	    terminated := true
	end)
    in
    dh.document_feed.feed_schedule
      (fun () ->
	 try let n = dh.document_feed.feed_read buffer 0 2048 in
	   if n = 0 then begin
	     hw.set_progress 100;
	     hw.add_text ""; (* special case to indicate end *)
	     abort ()
	     end
	   else begin
	     red := !red + n;
	     hw.set_progress (if size = 0 then 100 else !red * 100 / size);
	     hw.add_text (String.sub buffer 0 n)
	   end
	 with
	   Unix_error(_,_,_) ->
	     hw.set_progress (-1);
	     abort()
	   );
    Some { 
          di_widget = hw.widget;
	  di_abort = abort;
	  di_destroy = (fun () -> 
			 if Winfo.exists hw.widget then destroy hw.widget);
	  di_fragment = (fun s -> ());
	  di_redisplay = hw.redisplay;
      	  di_title = (fun () -> Url.string_of url);
      	  di_source = (fun () -> ());
      	  di_load_images = (fun () -> ());
          di_last_used = !Low.global_time}
    end


