/*--------------------------------*-C-*---------------------------------*
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * (nation@rocket.sanders.lockheed.com).
 * No additional restrictions are applied
 *
 * Additional modifications by mj olesen <olesen@me.queensu.ca>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _XSETUP_H
#define _XSETUP_H

#define RXVT_CLASS	"XTerm"	/* class name */

#include "sbar.h"		/* needed for sbar_type */

#define NEW_NAMES	0	/* don't change these values, they must */
#define NEW_ICON_NAME	1	/* match the normal XTerm convention for */
#define NEW_TITLE_NAME	2	/* interactive name setting */

extern Display		*Xdisplay;
extern XFontStruct	*Xfont;		/* main font structure */
extern GC		Xgc, Xrvgc;	/* GC for drawing text */
extern int		Xdepth;

extern unsigned char console;
extern unsigned char login_shell;
extern unsigned char iconic;
#ifndef ALWAYS_META_ESCAPE
extern unsigned char MetaHandling;
#endif
#ifdef MAPALERT
extern unsigned char map_alert;
extern KeySym ks_alert;
#endif
#ifdef VISUAL_BELL
extern unsigned char visual_bell;
#endif
extern char *rs_name;		/* the name the program is run under */
extern char *rs_title;		/* window name for titles etc. */
extern char *rs_iconName;	/* name to display in the icon */
extern char *rs_geometry;
extern char *display_name;

#ifdef COLOR
#ifdef USE_FAKE_BOLD
# define NCOLORS	10	/* bg, fg, [0-7] */
#else
# define NCOLORS	18	/* bg, fg, [0-7], bold 1[0-7] */
#endif
#else
# define NCOLORS	2
#endif

#define FG_COLOR	0
#define BG_COLOR	1
#define ANSI_COLOR0	2	/* 0 = black */
#define ANSI_COLOR1	3	/* 1 = red */
#define ANSI_COLOR2	4	/* 2 = green */
#define ANSI_COLOR3	5	/* 3 = yellow */
#define ANSI_COLOR4	6	/* 4 = blue */
#define ANSI_COLOR5	7	/* 5 = magenta */
#define ANSI_COLOR6	8	/* 6 = cyan */
#define ANSI_COLOR7	9	/* 7 = white */

#define BOLD_COLOR0	10	/* 0 = black */
#define BOLD_COLOR1	11	/* 1 = red */
#define BOLD_COLOR2	12	/* 2 = green */
#define BOLD_COLOR3	13	/* 3 = yellow */
#define BOLD_COLOR4	14	/* 4 = blue */
#define BOLD_COLOR5	15	/* 5 = magenta */
#define BOLD_COLOR6	16	/* 6 = cyan */
#define BOLD_COLOR7	17	/* 7 = white */

extern char *rs_color [NCOLORS];
extern unsigned long pixel_colors [NCOLORS];

#ifdef SINGLE_FONT
# define NFONTS		1
#else
# define NFONTS		5
extern KeySym ks_bigfont;
extern KeySym ks_smallfont;
#endif
extern char *rs_font [NFONTS];

#ifdef PRINT_PIPE
extern char *rs_print_pipe;
extern KeySym ks_printscreen;
#endif
#ifdef MULTIPLE_CLICKS
extern char *rs_cutchars;
#endif

#ifdef SECURE_KBD
extern KeySym ks_secure;
#endif
extern KeySym ks_pageup;
extern KeySym ks_pagedown;
#ifdef GREEK_SUPPORT
extern KeySym ks_greektoggle;
#endif

#ifdef __cplusplus
extern "C" {
#endif
   extern char *basename (char *string);
   extern void	String2Keysym (KeySym *keysym, char *string);
   extern void	init_display (int argc, char *argv[], char *cmd);
   extern void	resize_window (int, int);
   extern void	change_xterm_name (int op, char *str);
   extern void	print_error (char *fmt, ...);
   extern void	set_rs_font (char *list);
   extern void	new_font (int dirn);
   extern void	set_width (int cols);
#ifdef __cplusplus
}
#endif

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
