/*
*****************************************************************************
** FILE: callbacks.c
**
** xbmbrowser is Public Domain. However it, and all the code still belong to me.
** I do, however grant permission for you to freely copy and distribute it on 
** the condition that this and all other copyright notices remain unchanged in 
** all distributions.
**
** This software comes with NO warranty whatsoever. I therefore take no
** responsibility for any damages, losses or problems that the program may 
** cause.
**                                     Anthony Thyssen and Ashley Roll
*****************************************************************************
*/

#include "xbmbrowser.h"


void 
quit_browser()
/* Quit the application...
** The server de-allocates all pixmaps, colors, and widgets so just exit
** NOTE: This routine could be called directly, as a callback or as an event!
*/
{
  exit(0);
}


void 
set_name(widget, event)
/* This function is added to the notify callback on all the 
** menuButtons so that the global 'bitmap_info' contains the most 
** reciently selected bitmap information line. This is then used
** in  popup_user_menu() when a menu is requested to set the other
** information about the file the pointed to widget represents.
*/
  Widget   widget;
  XEvent  *event;
{
  /* don't display the type character (first character) of the info line */
  XtVaGetValues( widget, XtNlabel, &bitmap_info, NULL);
  XtVaSetValues( label,  XtNlabel,  bitmap_info+1, NULL );
}


void 
set_label(widget, event)
/* As the pointer leaves a window -- set the label widget to point to
** file counts and/or some error string stored in the label_info string.
*/
  Widget    widget;
  XEvent   *event;
{
  XtVaSetValues(label, XtNlabel, (XtArgVal)label_info, NULL);
}


void 
rescan(widget, client_data, call_data )
/* User pressed the rescan button -- so do it
** NOTE: no arguments used
*/
  Widget    widget;
  XtPointer client_data, call_data;
{
  set_busywait();
  rescan_bitmaps();
  clear_busywait();
}

void 
scan(widget, client_data, call_data )
/* User pressed the scan button -- so do it
** NOTE: no arguments used
*/
  Widget    widget;
  XtPointer client_data, call_data;
{
  set_busywait();
  scan_bitmaps();
  clear_busywait();
}


void 
dir_return(widget, event)
/* Event:- User pressed return in directory widget.
** Try to change directory to the dirwidget contents
** NOTE: Arguments not used.
*/
  Widget     widget;
  XEvent    *event;
{
  set_busywait();
  change_dir( XawDialogGetValueString(dirwidget) );
  clear_busywait();
}


void 
dir_menu(widget, client_data, call_data )
/* User selected a directory from the directory menu.
** Try to change dir to item selected by the user.
** NOTE: List widget call back data required.
*/
  Widget    widget;
  XtPointer client_data, call_data;
{
  XawListReturnStruct *dir = (XawListReturnStruct *)call_data;

  set_busywait();
  change_dir( dir->string );
  clear_busywait();
}


void
pos_dir(widget, event)
/* Event:- User is tring to popup directory menu.
** This procedure positions the menu under the cursour
*/
  Widget        widget;
  XButtonEvent *event;
{
  Position w;

  XtVaGetValues(dirmenu, XtNwidth, &w, NULL);
  XtVaSetValues(dirmenu, XtNx, event->x_root - w/2,
                         XtNy, event->y_root, NULL);
}


void
toggle_option(widget, client_data, call_data )
/* toggle the options in the options menu.
** NOTE: the client data is a pointer to the Boolean value which
** is to be toggled.
*/
  Widget     widget;
  XtPointer  client_data, call_data;
{
  Boolean *value = client_data;

  set_busywait();
  *value = !*value;
  XtVaSetValues(widget,
         XtNleftBitmap, *value ? tickon : tickoff, NULL);
  rescan_bitmaps();   /* show any changes to the bitmaps */
  clear_busywait();
}


void
popup_user_menu(widget, event)
/* Check the type of file image the user selected and either
** cd into the sub-directory, or popup the appropriate user menu.
** NOTE: This routine must be registered with XtRegisterGrabAction()
** for it to work properly.
**                                  --- Anthony Thyssen   2 May 1994
*/
  Widget        widget;
  XButtonEvent  *event;
{
  enum FileType  filetype = (enum FileType)(bitmap_info[0]-'A');
  Widget         popup_menu = NULL; /* menu to position and popup */

  assert( event->type == ButtonPress );  /* double check event type */

  /* Initialize substitution variables required for the user menu */

  /* From the bitmap_info pointer to the current bitmaps information line
  ** extract filename the current image represents.  This is used due the
  ** difficulity of storing a single pointer with a command widget pointing
  ** to the data structure the widget is representing. If this could be
  ** done, a lot of mucking around with the infomation line cound be
  ** avoided.                                --- Anthony Thyssen  24/7/93
  **
  ** NOTE: this proceedure assumes the format of the info line is
  **      <type_char>"<file_name>", <description>
  */
  /* extract the current filename from bitmap_info -- KLUDGE */
  { int length = rindex(bitmap_info, '\"') - bitmap_info - 2;
    strncpy(file_name, bitmap_info+2, length);
    file_name[length] = '\0';
  }

  /* At this point we may only need the filename */
  switch( event->button ) {
  case Button1:
    switch( filetype ) {
    case Dir:
    case DirUp:
    case DirLink:
    case DirBad:       /* CD into the directory selected */
      set_busywait();
      change_dir(file_name);
      clear_busywait();
      return;          /* done -- don't continue */
    }
    /* other wise just popup global menu */
  case Button2:
    /* regardless of icon type -- popup global menu */
    popup_menu = menu_global;
    break;
  case Button3:
  case Button4:
  case Button5:
    /* popup appropiate menu for the file type */
    switch( filetype ) {
    case Xbm:     popup_menu = menu_bitmap;    break;
    case Xpm:
    case XpmBad:  popup_menu = menu_pixmap;    break;
    case Dir:
    case DirUp:
    case DirLink:
    case DirBad:  popup_menu = menu_directory; break;
    default:      popup_menu = menu_other;     break;
    }
  }

  /* If this menu is defined -- complete substitution strings and pop it up */
  if( popup_menu != NULL ) {
    Position   w;    /* width of this menu */
    char      *s;    /* where the suffix starts in file_name */

    /* now complete the substitution list */
    /* extract the basename and suffix of the filename */
    s = rindex(file_name, '.');   /* find split point */
    if ( s == file_name || s == NULL ) {  
      /* The suffix is the whole filename OR non-existant */
      strcpy(base_name, file_name);  /* base_name = file_name */
      suffix[0] = '\0';              /* suffix = "" */
    } else {
      /* A valid split point was found -- split file_name */
      int len = s - file_name;
      strncpy(base_name, file_name,  len );  /* base_name is upto suffix */
      base_name[len] = '\0';
      strcpy(suffix, s);                   /* suffix (includes `.') */
    }

    /* the following should be a call like  XawPositionSimpleMenu(name) */
    XtRealizeWidget(popup_menu);  /* width is invalid unless realised */
    XtVaGetValues(popup_menu, XtNwidth, &w, NULL); /* get width */
    XtVaSetValues(popup_menu, XtNx, event->x_root - w/2,
                              XtNy, event->y_root,     NULL);
    /* OK now popup the menu -- and let user-menu take it from here */
    XtPopupSpringLoaded(popup_menu);
  } else {
    /* no action to perform -- beep user */
    XBell( event->display, 0 );
  }
}

