/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	Handles startup initialization, reading of .xldlasrc and quote of
	the day

        -------------------------------------------------------------------*/

#include "xldlas.h"


extern void say_status(char the_status[XLDLASMAX_INPUT]);
extern void toggle_type(void *data);
extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void log_init_output();
extern void texlog_init_output();
extern void htmllog_init_output();
extern void load_a_variable(FILE *lfptr);
extern char *add_blanks (char *inputstring);
extern void inhibit_input();
extern void reenable_input();
extern void do_column_import(FILE *the_file, char the_file_name[XLDLASMAX_INPUT]);
extern void do_row_import(FILE *the_file);


void read_rc_file(FILE *the_file)
{
	int line_number, errors_exist, i;
	char line_input[XLDLASMAX_INPUT];
	char first_string[XLDLASMAX_INPUT];
	char second_string[XLDLASMAX_INPUT];
	line_number = 0;
	errors_exist = FALSE;
	while(!feof(the_file))
	{
		fscanf(the_file,"%[^\n]",line_input);
		fscanf(the_file,"\n");
		line_number++;
		sscanf(line_input,"%s%s",first_string,second_string);
		if(first_string[0] != '#' || strlen(first_string) < 1)
		{
			errors_exist = TRUE;
			if(strcmp("quick_dropping",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &quick_dropping);
			}
			if(strcmp("graph_key_on",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &graph_key_on);
			}
			if(strcmp("graph_overwrite_on",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &graph_overwrite_on);
			}
			if(strcmp("graph_normal_on",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &graph_normal_on);
			}
			if(strcmp("ga_cross_ok",first_string) == 0) 
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_cross_ok);
			}
			if(strcmp("ga_mutate_ok",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_mutate_ok);
			}
			if(strcmp("ga_force",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_force);
			}
			if(strcmp("balloon_help",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &balloon_help);
			}
			if(strcmp("assume_sample",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &assume_sample);
			}
			if(strcmp("ga_perturbe_ok",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_perturbe_ok);
			}
			if(strcmp("pearls_of_wisdom",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &pearls_of_wisdom);
			}
			if(strcmp("main_font",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &main_font);
			}
			if(strcmp("missing_value", first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%f", &missing_value);
			}
			if(strcmp("numb_bars",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &numb_bars);
			}
			if(strcmp("ga_cycles",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_cycles);
			}
			if(strcmp("nn_cycles",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &nn_cycles);
			}
			if(strcmp("nn_learn",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%f", &nn_learn);
			}
			if(strcmp("nn_annealing",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &nn_annealing);
			}
			if(strcmp("nn_pictex",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &nn_pictex);
			}
			if(strcmp("nn_squash",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &nn_squash);
			}
			if(strcmp("ga_update",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_update);
			}
			if(strcmp("ga_mutate",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_mutate);
			}
			if(strcmp("ga_maxreal",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_maxreal);
			}
			if(strcmp("ga_bitsize",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_bitsize);
			}
			if(strcmp("ga_poolsize",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_poolsize);
			}
			if(strcmp("ga_swap",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_swap);
			}
			if(strcmp("ga_cross",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_cross);
			}
			if(strcmp("ga_perturbe",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_perturbe);
			}
			if(strcmp("ga_tolerance",first_string) == 0)
			{
				errors_exist = FALSE;
				sscanf(second_string,"%d", &ga_tolerance);
			}
			if(strcmp("graph_output_format",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(graph_output_format,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						graph_output_format[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					graph_output_format[i] = '\0';
				}
			}
			if(strcmp("graph_output_options",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(graph_output_options,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						graph_output_options[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					graph_output_options[i] = '\0';
				}
			}
			if(strcmp("gnuplot_geometry",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(gnuplot_geometry,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						gnuplot_geometry[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					gnuplot_geometry[i] = '\0';
				}
			}
			if(strcmp("print_command",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(print_command,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						print_command[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					print_command[i] = '\0';
				}
			}
			if(strcmp("tex_command",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(tex_command,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						tex_command[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					tex_command[i] = '\0';
				}
			}
			if(strcmp("dviview_command",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(dviview_command,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						dviview_command[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					dviview_command[i] = '\0';
				}
			}
			if(strcmp("dviprint_command",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(dviprint_command,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						dviprint_command[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					dviprint_command[i] = '\0';
				}
			}
			if(strcmp("tex_preamble",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(tex_preamble,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						tex_preamble[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					tex_preamble[i] = '\0';
				}
			}
			if(strcmp("tex_graphmacrol",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(tex_graphmacrol,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						tex_graphmacrol[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					tex_graphmacrol[i] = '\0';
				}
			}
			if(strcmp("tex_graphmacror",first_string) == 0)
			{
				errors_exist = FALSE;
				if(strlen(first_string) + 1 >= strlen(line_input))
				{
					strcpy(tex_graphmacror,"");
				}
				else
				{
					for(i = strlen(first_string) + 1; i < strlen(line_input); i++)
					{
						tex_graphmacror[i - (strlen(first_string) + 1)] = line_input[i];	
					}
					tex_graphmacror[i] = '\0';
				}
			}
			if(errors_exist == TRUE)
			{
				sprintf(second_string,"Bad option in line %d of ~/.xldlasrc. Line reads: %s\n", line_number, line_input);
				simple_line_output("err",second_string);
			}
		}
	}
}


void make_rc_file(FILE *the_file)
{
	fprintf(the_file,"#-----------------------------------------------------\n");
	fprintf(the_file,"#  This file was automatically created by xldlas	\n");
	fprintf(the_file,"#							\n");
	fprintf(the_file,"#  It includes default settings for all user		\n");		
	fprintf(the_file,"#  configurable options.				\n");
	fprintf(the_file,"#							\n");
	fprintf(the_file,"#  It is safer to edit this file from xldlas		\n");
	fprintf(the_file,"#  (using the preferences button) than it is to	\n");
	fprintf(the_file,"#  manually edit it.					\n");
	fprintf(the_file,"#-----------------------------------------------------\n");
	fprintf(the_file,"#  SECTION I - flags 					\n");
	fprintf(the_file,"#  1 = True, 0 = False				\n");
	fprintf(the_file,"#							\n");
	fprintf(the_file,"quick_dropping %d\n", quick_dropping);
	fprintf(the_file,"graph_key_on %d\n", graph_key_on);
	fprintf(the_file,"graph_overwrite_on %d\n", graph_overwrite_on);
	fprintf(the_file,"graph_normal_on %d\n", graph_normal_on);
	fprintf(the_file,"ga_force %d\n", ga_force);
	fprintf(the_file,"ga_cross_ok %d\n", ga_cross_ok);
	fprintf(the_file,"ga_mutate_ok %d\n", ga_mutate_ok);
	fprintf(the_file,"ga_perturbe_ok %d\n", ga_perturbe_ok);
	fprintf(the_file,"pearls_of_wisdom %d\n", pearls_of_wisdom);
	fprintf(the_file,"nn_annealing %d\n", nn_annealing);
	fprintf(the_file,"nn_pictex %d\n", nn_pictex);
	fprintf(the_file,"balloon_help %d\n", balloon_help);
	fprintf(the_file,"assume_sample %d\n", assume_sample);
	fprintf(the_file,"#							\n");
	fprintf(the_file,"#  SECTION II - parameters				\n");
	fprintf(the_file,"#  missing_value and nn_learn are read as floats	\n");
	fprintf(the_file,"#  all others are integers				\n");
	fprintf(the_file,"#							\n");
	fprintf(the_file,"missing_value %f\n", missing_value);
	fprintf(the_file,"numb_bars %d\n", numb_bars);
	fprintf(the_file,"ga_cycles %d\n", ga_cycles);
	fprintf(the_file,"nn_cycles %d\n", nn_cycles);
	fprintf(the_file,"nn_learn %f\n", nn_learn);
	fprintf(the_file,"nn_squash %d\n", nn_squash);
	fprintf(the_file,"ga_update %d\n", ga_update);
	fprintf(the_file,"ga_mutate %d\n", ga_mutate);
	fprintf(the_file,"ga_maxreal %d\n", ga_maxreal);
	fprintf(the_file,"ga_bitsize %d\n", ga_bitsize);
	fprintf(the_file,"ga_poolsize %d\n", ga_poolsize);
	fprintf(the_file,"ga_swap %d\n", ga_swap);
	fprintf(the_file,"ga_cross %d\n", ga_cross);
	fprintf(the_file,"ga_perturbe %d\n", ga_perturbe);
	fprintf(the_file,"ga_tolerance %d\n", ga_tolerance);
	fprintf(the_file,"main_font %d\n", main_font);
	fprintf(the_file,"#							\n");
	fprintf(the_file,"#  SECTION III - Strings				\n");
	fprintf(the_file,"#  read as free form strings from one character	\n");
	fprintf(the_file,"#  after the variable					\n");
	fprintf(the_file,"#							\n");
	fprintf(the_file,"graph_output_format %s\n", graph_output_format);
	fprintf(the_file,"graph_output_options %s\n", graph_output_options);
	fprintf(the_file,"gnuplot_geometry %s\n", gnuplot_geometry);
	fprintf(the_file,"print_command %s\n", print_command);
	fprintf(the_file,"tex_command %s\n", tex_command);
	fprintf(the_file,"dviview_command %s\n", dviview_command);
	fprintf(the_file,"dviprint_command %s\n", dviprint_command);
	fprintf(the_file,"tex_preamble %s\n", tex_preamble);
	fprintf(the_file,"tex_graphmacrol %s\n", tex_graphmacrol);
	fprintf(the_file,"tex_graphmacror %s\n", tex_graphmacror);
}

int handle_rc_stuff()
{
	FILE *rc_file;
	int i;
	char searcher[XLDLASMAX_INPUT];
	char home_dir[XLDLASMAX_INPUT];
	char	**env = environ;
	while (*env)
	{
		strcpy(searcher, *env);
		if(strncmp("HOME=", searcher, 5) == FALSE)
		{
			for(i=5; i< XLDLASMAX_INPUT; i++)
			{
				home_dir[i-5] = searcher[i];
				if(searcher[i] == '\0')
				{
					i = XLDLASMAX_INPUT;
				}
			}
		}
		env++;
	}
	strcat(home_dir,"/.xldlasrc");
	rc_file = fopen(home_dir,"r");
	if(!rc_file)
	{
		rc_file = fopen(home_dir,"w");
		if(!rc_file)
		{
			return(-2);
		}
		make_rc_file(rc_file);
		return(1);
	}
	else
	{
		read_rc_file(rc_file);
		fclose(rc_file);
		return(0);
	}
	return(-2);
}

void assign_help_files()
{
	int i;
	char searcher[XLDLASMAX_INPUT];
	int found_label;
	char	**env = environ;
	found_label = FALSE;
	while (*env)
	{
		strcpy(searcher, *env);
		if(strncmp("XLDLAS_HELPDIR=\0", searcher, 15) == FALSE)
		{
			found_label = TRUE;
			for(i=15; i< XLDLASMAX_INPUT; i++)
			{
				help_location[i-15] = searcher[i];
				if(searcher[i] == '\0')
				{
					if(i==15)
					{
						found_label= FALSE;
					}
					else
					{
						if(help_location[i-16] != '/')
						{
							help_location[i-15] = '/';
							help_location[i-14] = '\0';
						}
					}
					i = 1204;
				}
			}
		}
	env++;
	}
	for(i=1; i <= 8; i++)
	{
		help_exists[i] = FALSE;
	}
	
	if(found_label == FALSE)
		strcpy(help_location,"/usr/local/xldlas/help/");
	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"general.help");
	if(system(searcher) == 0) help_exists[1] = TRUE;
	else help_exists[1] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"file.help");
	if(system(searcher) == 0) help_exists[2] = TRUE;
	else help_exists[2] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"data.help");
	if(system(searcher) == 0) help_exists[3] = TRUE;
		else help_exists[3] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"log.help");
	if(system(searcher) == 0) help_exists[4] = TRUE;
		else help_exists[4] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"graph.help");
	if(system(searcher) == 0) help_exists[5] = TRUE;
		else help_exists[5] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"analysis.help");
	if(system(searcher) == 0) help_exists[6] = TRUE;
		else help_exists[6] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"test.help");
	if(system(searcher) == 0) help_exists[7] = TRUE;
		else help_exists[7] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"filter.help");
	if(system(searcher) == 0) help_exists[8] = TRUE;
		else help_exists[8] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"license.help");
	if(system(searcher) == 0) help_exists[9] = TRUE;
		else help_exists[9] = FALSE;

	strcpy(searcher,"test -r ");
	strcat(searcher, help_location);
	strcat(searcher,"tutorial.help");
	if(system(searcher) == 0) help_exists[10] = TRUE;
		else help_exists[10] = FALSE;

} 

void set_startup_defaults()
{
	int i,j;
	missing_value = XLDLAS_MISSING;
	quick_dropping = QUICK_DROPPING;
	graph_key_on = XLDLAS_DEFAULT_KEY_BUTTON;
	graph_overwrite_on = XLDLAS_DEFAULT_OVERWRITE_BUTTON;
	graph_normal_on = XLDLAS_DEFAULT_NORMAL_BUTTON;
	strcpy(graph_output_format, XLDLAS_DEFAULT_OUTPUT_FORMAT);
	strcpy(graph_output_options,XLDLAS_DEFAULT_OUTPUT_OPTIONS);
	numb_bars = XLDLAS_DEFAULT_HIST_BARS;
	strcpy(gnuplot_geometry,XLDLAS_DEFAULT_GNUPLOT_GEOMETRY);
	ga_cycles = XLDLAS_DEFAULT_GA_CYCLES;
	nn_cycles = XLDLAS_DEFAULT_NN_CYCLES;
	nn_pictex = XLDLAS_DEFAULT_NN_PICTEX;
	nn_hidden = XLDLAS_DEFAULT_NN_HIDDEN;
	nn_learn = XLDLAS_DEFAULT_NN_LEARN;
	nn_annealing = XLDLAS_DEFAULT_NN_ANNEALING;
	nn_squash = XLDLAS_DEFAULT_NN_SQUASH;
	ga_update = XLDLAS_DEFAULT_GA_UPDATE;
	ga_mutate = XLDLAS_DEFAULT_GA_MUTATE;
	ga_force = TRUE;
	ga_maxreal = XLDLAS_DEFAULT_GA_MAXREAL;
	ga_bitsize = XLDLAS_DEFAULT_GA_BITSIZE;
	ga_poolsize = XLDLAS_DEFAULT_GA_POOLSIZE;
	ga_swap = XLDLAS_DEFAULT_GA_SWAP;
	ga_cross = XLDLAS_DEFAULT_GA_CROSS;
	ga_perturbe = XLDLAS_DEFAULT_GA_PERTURBE;
	ga_tolerance = XLDLAS_DEFAULT_GA_TOLERANCE;
	ga_mutate_ok = TRUE;
	ga_cross_ok = TRUE;
	ga_perturbe_ok = TRUE;
	strcpy(print_command,XLDLAS_DEFAULT_PRINT_COMMAND);
	strcpy(tex_command,XLDLAS_DEFAULT_TEX_COMMAND);
	strcpy(dviview_command,XLDLAS_DEFAULT_DVIVIEW_COMMAND);
	strcpy(dviprint_command,XLDLAS_DEFAULT_DVIPRINT_COMMAND);
	strcpy(tex_preamble,XLDLAS_DEFAULT_TEX_PREAMBLE);
	strcpy(tex_graphmacrol,XLDLAS_DEFAULT_TEX_GRAPHMACROL);
	strcpy(tex_graphmacror,XLDLAS_DEFAULT_TEX_GRAPHMACROR);
	pearls_of_wisdom = TRUE;
	main_font = 2;
	anova_type = XLDLAS_DEFAULT_ANOVA_TYPE;
	balloon_help = TRUE;
	main_offset = 0;
	graph_window_open = FALSE;
	assume_sample = FALSE;
	for(i = 0; i < XLDLAS_NUMB_WINDOWS; i++)
	{
		for(j = 0; j < 4; j++)
		{
			window_geometry[i][j] = -1;
		}
	} 
}


int startup()
{
	int status;
	time_t curtime;
	int seedval;
	oktoquit = TRUE;
	data_exists = FALSE;
	numb_variables = 0;	
	/*
		(Pseudo-)Randomly Seed the (Pseudo-)Random Number Generator
	*/
	curtime = time(NULL);
	seedval = curtime;
	srand(seedval);
	assign_help_files();
	strcpy(data_matrix_description,"\0");
	real_drop = TRUE;
	import_type = TYPE_COLS;
	log_on = FALSE;
	texlog_on = FALSE;
	htmllog_on = FALSE;
	log_verbose_on = FALSE;
	htmllog_verbose_on = FALSE;
	texlog_verbose_on = FALSE;
	strcpy(log_name,"");
	strcpy(texlog_name,"");
	strcpy(htmllog_name,"");
	general_abort = FALSE;
	set_startup_defaults();
	status = handle_rc_stuff();
	return(status);
}

void opening_quote()
{
	int hmm;
	if(pearls_of_wisdom == FALSE) return;
	say_status("Pearls of wisdom ...");
	hmm = rand() % 42;
	switch (hmm)
	{
		case 0 : fl_show_message("\"To express anything important in mere figures is so plainly impossible that there must",
					 "be endless scope for well paid advice on how to do it.\"",
					 "- Manderville");break;
		case 1 : fl_show_message("\"But when the statistical cook turns to raw materials ... he substitutes green garment die",
					 "for curry, ping-pong balls for turtle's eggs, and, for Chalifougnac",
					 "vintage 1883, a can of turpentine.\"     - Valavanis"); break;
		case 2 : fl_show_message("\"Hendry notes that the word econometrics should not be confused with",
					 "`economystics,' `economic-tricks,' or `icon-ometrics.' \"",
					 "- Kennedy");break;
		case 3 : fl_show_message("\"All econometric models break down when used for policy.\"",
					 "",
					 "- Goodhart's Law");break;
		case 4 : fl_show_message("\"Regressions on government-collected data have been used mainly to bolster one theoretical",
					 "argument over another. But the bolstering they provide is weak, ...  and easily",
					 "countered by someone else's regressions.\"     -Bergmann");break;
		case 5 : fl_show_message("\"[Econometrics is] the art of drawing a crooked line from",
					 "an unproved assumption to a foregone conclusion.\"",
					 "- Kennedy");break;
		case 6 : fl_show_message("\"But what you must never forget is that every one of those figure comes in the first",
					 "instance from the village watchman, who just puts down what he damn pleases.\"", 
					 "- Stamp");break;
		case 7 : fl_show_message("\"If an economist is someone who guesses wrong about the economy, an econometrician is",
					 "someone who uses a computer to guess wrong about the economy.\"",
					 "- Kennedy");break;
		case 8 : fl_show_message("\"[Forecasters] only forecast to show the world that we have a sense of humour.\"",
					 "",
					 "- Kennedy");break;
		case 9 : fl_show_message("\"One of the great mistakes of the past 30 years of economic policy has been an", 
					 "excessive belief in the ability to forecast.\"",
					 "- Feldstein");break;
		case 10: fl_show_message("\"... in no other field of empirical enquiry has so massive and sophisticated a statistical",
					 "machinery been used with such indifferent results [as in economics].\"",
					 "- Leontief");break;
		case 11: fl_show_message("\"There are three kinds of lies: lies, damned lies, and statistics.\"",
					 "",
					 "- Disraeli (et al)");break;
		case 12: fl_show_message("\"Statistical thinking will one day be as necessary for efficient",
					 "citizenship as the ability to read and write.\"",
					 "- Wells");break;
		case 13: fl_show_message("\"Round numbers are always false.\"",
					 "",
					 "- Johnson");break;
		case 14: fl_show_message("\"Averages and relationships and trends and graphs are not always what they seem. There",
					 "may be more in them than meets the eye, and there may be a good deal less.\"",
					 "- Huff");break;
		case 15: fl_show_message("\"A well-wrapped statistic is better than Hitler's `big lie'; it",
					 "misleads, yet it cannot be pinned on you.\"",
					 "- Huff");break;
		case 16: fl_show_message("\"If you have a barrel of beans, some red and some white, there is only",
					 "one way to find out exactly how many of each color you have: Count 'em.\"",
					 "- Huff");break;
		case 17: fl_show_message("\"As [is] usually true with income figures, an unqualified `average' is virtually meaningless.\"",
					 "",
					 "- Huff");break;
		case 18: fl_show_message("\"If you work half-time one year and full-time the next, your earnings will double,", 
					 "but that doesn't indicate anything at all about your wage rate.\"",
					 "- Huff");break;
		case 19: fl_show_message("\"I have just tried ten tosses and got heads eight times, which proves", 
					 "that pennies come up heads eighty percent  of the time.\"",
					 "- Huff");break;
		case 20: fl_show_message("\"Your probably guessed I just made up [$60] for purposes of illustration, but I'll",
					 " bet you wouldn't have if I'd  used $59.83 instead.\"",
					 "- Huff");break;
		case 21: fl_show_message("\"You can, for instance, express exactly the same fact by calling it a 1% return on sales, a 15%",
					 "return on investment, a 10 million dollar profit, or a decrease of sixty percent from last year.\"",
					 "- Huff");break;
		case 22: fl_show_message("\"The above data, which may be relied upon, were given to me by a Manchester spinner.\"",
					 "",
					 "- Marx");break;
		case 23: fl_show_message("\"Buy your Christmas presents now and save 100 percent.\"",
					 "",
					 "- Advertisement");break;
		case 24: fl_show_message("\"[Workers] affiliated with the Indianapolis Building Trade Unions were given a 5% increase",
					 "in wages. That gave back to the men one fourth of the 20% cut they took last winter.\"",
					 "- New York Times");break;
		case 25: fl_show_message("\"The average Welshman has more than the average number of legs.\"",
					 "",
					 "- Baker");break;
		case 26: fl_show_message("\"Introspection is the most important empirical tool.\"",
					 "",
					 "- Hogan");break;
		case 27: fl_show_message("\"Platykurtic [distributions] have short tails like a platypus, while leptokurtic", 
					 "[distributions] have long tails like kangaroos, noted for `lepping'.\"",
					 "- Gosset");break;
		case 28: fl_show_message("\"Now matter how well you estimate the Bayesian probabilities, you should recognize",
					 "that these values are neither intuitively obvious nor even readily obtained.\"",
					 "- Harnett");break;
		case 29: fl_show_message("\"When the emphasis is upon the use of numerical facts without a careful consideration of the",
					 "methods of collection and interpretation, then statistical data can become all things to all men.\"",
					 "- Rosander");break;
		case 30: fl_show_message("\" `Facts' are conditioned by, and are a product of, the particular process used to obtain them.\"",
					 "",
					 "- Rosander");break;
		case 31: fl_show_message("\" `Facts' may be distorted by the prejudices of the persons who collect,",
					 "select, and publish them.\"",
					 "- Rosander");break;
		case 32: fl_show_message("\"If you believe [econometricians], then you also believe in the tooth fairy.\"",
					 "",
					 "- Regan");break;
		case 33: fl_show_message("\"All macroeconomic variables are random walks.\"",
					 "",
					 "- Ragan");break;
		case 34: fl_show_message("\"It is not uncommon, in real life, to be dealing with a distribution",
					 "whose second moment does not exist.\"",
					 "- Numerical Recipes in C");break;
		case 35: fl_show_message("\"[Kurtosis] measures the relative peakedness or flatness of a distribution.",
					 "Relative to what? A normal distribution, what else?\"",
					 "- Numerical Recipes in C");break;
		case 36: fl_show_message("\"[Interpretations] of the r statistic can be completely meaningless if the joint probability",
					 "distribution of your variables ... is too different from a binomial distribution\"",
					 "- Numerical Recipes in C");break;
		case 37: fl_show_message("\"This identification is entirely based on intuition. It has no formal mathematical basis in and of",
					 "itself; as we already remarked, statistics is not a branch of mathematics!\"",
					 "- Numerical Recipes in C");break;
		case 38: fl_show_message("\"The economy depends about as much on economists as the weather does on",
					 "weather forecasters.\"",
					 "- Kauffmann");break;
		case 39: fl_show_message("\"The Unmeasurable Lightness of Being:",
					  "Economic statistics can cause governments to lose elections or wipe billions",
					  "off share prices. Unfortunately, many of the numbers are wrong.\"  - The Economist"); break;
		case 40: fl_show_message("\"It is better to be roughly right than precisely wrong.\"",
					  "",
					  "- Keynes"); break;
		case 41: fl_show_message("\"If all else fails, immortality can always be assured by",
					  "spectacular error\"",
					  "- Galbraith"); break;
	}
}

void handle_cloptions(int numb_arguments, char *arguments[])
{
	int i, j, didsomething, count, dubious, choice;
	char string_one[XLDLASMAX_INPUT];
	FILE *lfptr;
	for(i = 1; i < numb_arguments; i++)
	{
		didsomething = FALSE;
		if(strcmp(arguments[i],"-log") == 0 && didsomething == FALSE)
		{
			didsomething = TRUE;
			if(i + 1 < numb_arguments && strncmp(arguments[i+1],"-",1) != 0)
			{
				sprintf(string_one, arguments[i+1]);
				log_file = fopen(string_one,"a");
				if(!log_file)
				{
					fl_show_alert("Sorry, could not open the requested file as a log.","(Is it a legal file name?)","",TRUE);
					return;
				}
				strcpy(log_name,string_one);
				log_verbose_on = TRUE;
				log_on = TRUE;
				sprintf(string_one, "Log File Opened on %s",arguments[i+1]);
				simple_line_output("start", string_one);
				log_init_output();
				i++; 
			}
			else
			{
				simple_line_output("start","ERROR: log option specified with no file name");
			}
		}	
		if(strcmp(arguments[i],"-tlog") == 0 && didsomething == FALSE)
		{
			didsomething = TRUE;
			if(i + 1 < numb_arguments && strncmp(arguments[i+1],"-",1) != 0)
			{
				sprintf(string_one, arguments[i+1]);
				texlog_file = fopen(string_one,"a");
				if(!texlog_file)
				{
					fl_show_alert("Sorry, could not open the requested file as a TeXLog","(Is it a legal file name?)","",TRUE);
					return;
				}
				strcpy(texlog_name,string_one);
				texlog_verbose_on = TRUE;
				texlog_on = TRUE;
				sprintf(string_one, "TeXLog File Opened on %s",arguments[i+1]);
				simple_line_output("start", string_one);
				texlog_init_output();
				i++; 
			}
			else
			{
				simple_line_output("start","ERROR: tlog option specified with no file name");
			}
		}	
		if(strcmp(arguments[i],"-hlog") == 0 && didsomething == FALSE)
		{
			didsomething = TRUE;
			if(i + 1 < numb_arguments && strncmp(arguments[i+1],"-",1) != 0)
			{
				sprintf(string_one, arguments[i+1]);
				htmllog_file = fopen(string_one,"a");
				if(!htmllog_file)
				{
					fl_show_alert("Sorry, could not open the requested file as an HTML Log","(Is it a legal file name?)","",TRUE);
					return;
				}
				strcpy(htmllog_name,string_one);
				htmllog_verbose_on = TRUE;
				htmllog_on = TRUE;
				sprintf(string_one, "HTML Log File Opened on %s",arguments[i+1]);
				simple_line_output("start", string_one);
				htmllog_init_output();
				i++; 
			}
			else
			{
				simple_line_output("start","ERROR: hlog option specified with no file name");
			}
		}	
		if(strcmp(arguments[i],"-icol") == 0 && didsomething == FALSE)
		{
			didsomething = TRUE;
			if(i + 1 < numb_arguments && strncmp(arguments[i+1],"-",1) != 0)
			{
				sprintf(string_one, arguments[i+1]);
				lfptr = fopen(string_one,"r");
				if(!lfptr)
				{
					fl_show_alert("Sorry, could not open the requested file to import data","(Is it a legal file name?)","",TRUE);
					return;
				}
				inhibit_input();
				do_column_import(lfptr, string_one);
				reenable_input();
				i++; 
			}
			else
			{
				simple_line_output("start","ERROR: icol option specified with no file name");
			}
		}	
		if(strcmp(arguments[i],"-irow") == 0 && didsomething == FALSE)
		{
			didsomething = TRUE;
			if(i + 1 < numb_arguments && strncmp(arguments[i+1],"-",1) != 0)
			{
				sprintf(string_one, arguments[i+1]);
				lfptr = fopen(string_one,"r");
				if(!lfptr)
				{
					fl_show_alert("Sorry, could not open the requested file to import data","(Is it a legal file name?)","",TRUE);
					return;
				}
				inhibit_input();
				do_row_import(lfptr);
				i++; 
			}
			else
			{
				simple_line_output("start","ERROR: icol option specified with no file name");
			}
		}	
		if(didsomething == FALSE)
		{
			if(strncmp(arguments[i],"-",1) == 0)
			{
				sprintf(string_one,"ERROR: Command line option is invalid: %s", arguments[i]);
				simple_line_output("start", string_one);
			}
			else
			{
				lfptr = fopen(arguments[i],"r");
				if(!lfptr)
				{
					sprintf(string_one, "ERROR: Could not open requested file (%s) for reading", arguments[i]);
					simple_line_output("start", string_one);
				}
				else
				{
					inhibit_input();
					fscanf(lfptr,"%s\n",data_matrix_description);
					dubious = TRUE;
					for(j = 0; j < strlen(data_matrix_description); j++)
					{
						if(data_matrix_description[j] == '_') dubious = FALSE;
					}
					if(dubious == TRUE)
					{
					#ifdef XFORMS86
						choice = fl_show_choice("Hmmm. The File being loaded Seems Strange",
									"I doubt it's in .lda format","Should I try to Continue?",
        				       				3,"Yes","No","Cancel",2);
					#else
						choice = fl_show_choice("Hmmm. The File being loaded Seems Strange",
									"I doubt it's in .lda format","Should I try to Continue?",
        				       				3,"Yes","No","Cancel");
        				#endif
						if(choice == 2 || choice == 3)
						{
							strcpy(data_matrix_description,"");
							fclose(lfptr);
							say_status("Ready");
							reenable_input();
							return;
						}
					}
					fscanf(lfptr,"%f\n",&missing_value);
					while(!feof(lfptr))
					{
						load_a_variable(lfptr);
					}
					fclose(lfptr);
					strcpy(data_matrix_description,add_blanks(data_matrix_description));
					for(count = 0; count < numb_variables; count++)
					{
						strcpy(data_matrix[count].description,add_blanks(data_matrix[count].description));
						strcpy(data_matrix[count].name,add_blanks(data_matrix[count].name));
					}
					data_exists = TRUE;
					oktoquit = TRUE;
					sprintf(string_one,"Loaded %d variable(s) into memory from %s", numb_variables, arguments[i]);
					simple_line_output("start",string_one);
					reenable_input();
				}
			}
		}	
	}
}

int check_for_command_line_help(int numb_arguments, char *arguments[])
{
	int i;
	for(i = 1; i < numb_arguments; i++)
	{
		if(strcmp(arguments[i],"-help") == 0 ||
		   strcmp(arguments[i],"-h") == 0 ||
		   strcmp(arguments[i],"--help") == 0)
		{
		   	printf("\nxldlas v%d.%d -- A Program for Statistics\n", XLDLAS_MAJOR, XLDLAS_MINOR);
			printf("Copyright (C) 1996, 1997 Thor Sigvaldason\n\n");
			printf("The following command line options are available:\n\n");
			printf("	-h			Display this help\n");
			printf("	-help			Display this help\n");
			printf("	--help			Display this help\n");
			printf("	-v			Display version information\n");
			printf("	-version		Display version information\n");
			printf("	--version		Display version information\n");
			printf("	-display name		Run on display specified by name\n");
			printf("	-private		Use a private colourmap\n");
			printf("	-shared			Share the colourmap (ie. avoid flashing)\n");
			printf("	-stdcmp			Use a standard colourmap\n");
			printf("	-double			Enable double buffering\n");
			printf("	-log name		Open standard log on file specified by name\n");
			printf("	-tlog name		Open TeX format log on file specified by name\n");
			printf("	-hlog name		Open HTML format log on file specified by name\n");
			printf("	-irow name		Import row-format ascii data from name\n");
			printf("	-ical name		Import column-format ascii data from name\n");
			printf("	lda_file_name		Load .lda data from lda_file_name\n");
			printf("\n");
			return(TRUE);
		}
		if(strcmp(arguments[i],"-v") == 0 ||
		   strcmp(arguments[i],"-version") == 0 ||
		   strcmp(arguments[i],"--version") == 0)
		{
		   	printf("xldlas v%d.%d -- A Program for Statistics\n", XLDLAS_MAJOR, XLDLAS_MINOR);
			printf("Copyright (C) 1996, 1997 Thor Sigvaldason\n");
			return(TRUE);
		}
	}
	return(FALSE);
}
