// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <kapp.h>

#include "Options.h"

Options::Options()
{
    _config = KApplication::getKApplication()->getConfig();
}

void Options::sync()
{
    _config->sync();
}

bool Options::getShowTxRate()
{
    return _config->readNumEntry( "showTxRate", TRUE );
}

bool Options::getShowRxRate()
{
    return _config->readNumEntry( "showRxRate", TRUE );
}

bool Options::getShowTxTotal()
{
    return _config->readNumEntry( "showTxTotal", TRUE );
}

bool Options::getShowRxTotal()
{
    return _config->readNumEntry( "showRxTotal", TRUE );
}

int Options::getStatsInterval()
{
    return _config->readNumEntry( "statsInterval", 5 );
}

int Options::getPeriodicInterval()
{
    return _config->readNumEntry( "periodicInterval", 0 );
}

const QString Options::getPPPCommand()
{
    return _config->readEntry( "pppCommand", 0 );
}

const QString Options::getPeriodicCommand()
{
    return _config->readEntry( "periodicCommand", 0 );
}

int Options::getLinkNumber()
{
    return _config->readNumEntry( "linkNumber", 0 );
}

int Options::getRetryInterval()
{
    return _config->readNumEntry( "retryInterval", 60 );
}

int Options::getRateDivider()
{
    return _config->readNumEntry( "rateDivider", 1024 );
}

int Options::getStatsPeriod()
{
    return _config->readNumEntry( "statsPeriod", 60 );
}

QColor Options::getRxColor()
{
    return _config->readColorEntry( "rxColor", &QColor( "red" ) );
}

QColor Options::getTxColor()
{
    return _config->readColorEntry( "txColor", &QColor( "darkblue" ) );
}

void Options::setShowTxRate( bool b )
{
    if ( b != getShowTxRate() ) {
        _config->writeEntry( "showTxRate", b );
        emit sigShowTxRate();
    }
}

void Options::setShowRxRate( bool b )
{
    if ( b != getShowRxRate() ) {
        _config->writeEntry( "showRxRate", b );
        emit sigShowRxRate();
    }
}

void Options::setShowTxTotal( bool b )
{
    if ( b != getShowTxTotal() ) {
        _config->writeEntry( "showTxTotal", b );
        emit sigShowTxTotal();
    }
}

void Options::setShowRxTotal( bool b )
{
    if ( b != getShowRxTotal() ) {
        _config->writeEntry( "showRxTotal", b );
        emit sigShowRxTotal();
    }
}

void Options::setStatsInterval( int i )
{
    if ( i != getStatsInterval() ) {
        _config->writeEntry( "statsInterval", i );
        emit sigStatsInterval();
    }
}

void Options::setPeriodicInterval( int i )
{
    if ( i != getPeriodicInterval() ) {
        _config->writeEntry( "periodicInterval", i );
        emit sigPeriodicInterval();
    }
}

void Options::setPPPCommand( const char* str )
{
    if ( getPPPCommand() != str ) {
        _config->writeEntry( "pppCommand", str );
        emit sigPPPCommand();
    }
}

void Options::setPeriodicCommand( const char* str )
{
    if ( getPeriodicCommand() != str ) {
        _config->writeEntry( "periodicCommand", str );
        emit sigPeriodicCommand();
    }
}

void Options::setLinkNumber( int i )
{
    if ( i != getLinkNumber() ) {
        _config->writeEntry( "linkNumber", i );
        emit sigLinkNumber();
    }
}

void Options::setRetryInterval( int i )
{
    if ( i != getRetryInterval() ) {
        _config->writeEntry( "retryInterval", i );
        emit sigRetryInterval();
    }
}

void Options::setRateDivider( int i )
{
    if ( i != getRateDivider() ) {
        _config->writeEntry( "rateDivider", i );
        emit sigRateDivider();
    }
}

void Options::setStatsPeriod( int i )
{
    if ( i != getStatsPeriod() ) {
        _config->writeEntry( "statsPeriod", i );
        emit sigStatsPeriod();
    }
}

void Options::setRxColor( QColor c )
{
    if ( c != getRxColor() ) {
        _config->writeEntry( "rxColor", c );
        emit sigRxColor();
    }
}

void Options::setTxColor( QColor c )
{
    if ( c != getTxColor() ) {
        _config->writeEntry( "txColor", c );
        emit sigTxColor();
    }
}
