// pppload - A PPP Load Monitor
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _MainWindow_H_
#define _MainWindow_H_

#include <qwidget.h>
#include <qpixmap.h>

//: Main window of PPPLoad.
//. The MainWindow takes PPP stats updates from a PPPStats object, and draws
//. a graph of the transmit and receive rates.  Below the graph, the total
//. number of bytes transmitted and received is displayed.
class MainWindow : public QWidget {
	Q_OBJECT;
	//: The size of the history arrays (basically the width of the window).
	int  _historySize;
	//: Array of last n transmit rates.
	int* _txHistory;
	//: Array of last n receive rates.
	int* _rxHistory;
	//: The size of the data arrays.
	int  _dataSize;
	//: Array of transmit data for computing average.
	int* _txData;
	//: Array of receive data for computing average.
	int* _rxData;
	//: Average transmit rate.
	int  _txAverage;
	//: Average receive rate.
	int  _rxAverage;
	//: Current maximum transfer rate.
	int _max;
	//: Width of one character.
	int _fontWidth;
	//: Height of one character.
	int _fontHeight;
	//: Baseline for the font.
	int _fontBaseline;
	//: Last transmit total string.
	QString _txStr;
	//: Last receive total string.
	QString _rxStr;
	//: Off-screen buffer for drawing and paint events.
	QPixmap _pixmap;

	//: Convert a number of bytes to a reasonable string.
	QString bytesToString( int bytes );
	//: Redraw the graph using the stored data.
	void redrawGraph();
 protected:
	//: Rescale the graph to fit in the new window size.
	virtual void resizeEvent( QResizeEvent* e );
	//: Redraw the contents of the window.
	virtual void paintEvent( QPaintEvent* e );
 public:
	//: Create the main window.
	MainWindow( QWidget* parent=0, const char* name=0 );
 public slots:
	//: Process the stats update from a PPPStats object.
	void updateStats( unsigned int rxDelta, unsigned int txDelta, unsigned int rxTotal, unsigned int txTotal );
	
	//: Process a link down indication.
	void linkDown();
};

#endif
