// pppload - A PPP Load Monitor
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

extern "C" {
#include <stdio.h>
}

#include "Options.H"

Options::Options( int argc, char* argv[] )
: _divider( 512 ), _interval( 5 ), _link( 0 ), _period( 60 ), _retry( 60 ), _showTx( true ), _showRx( true ), _txColor( "forestgreen" ), _rxColor( "red" )
{
	for ( int i = 1; i < argc; i++ ) {
		if ( !strcmp( argv[i], "-cmd" ) ) {
			_cmd = argv[++i];
		} else if ( !strcmp( argv[i], "-d" ) ) {
			sscanf( argv[++i], "%d", &_divider );
		} else if ( !strcmp( argv[i], "-i" ) ) {
			sscanf( argv[++i], "%d", &_interval );
		} else if ( !strcmp( argv[i], "-link" ) ) {
			sscanf( argv[++i], "%d", &_link );
		} else if ( !strcmp( argv[i], "-p" ) ) {
			sscanf( argv[++i], "%d", &_period );
		} else if ( !strcmp( argv[i], "-retry" ) ) {
			sscanf( argv[++i], "%d", &_retry );
		} else if ( !strcmp( argv[i], "-rx" ) ) {
			_showRx = true;
		} else if ( !strcmp( argv[i], "-norx" ) ) {
			_showRx = false;
		} else if ( !strcmp( argv[i], "-rxcolor" ) ) {
			_rxColor.setNamedColor( argv[++i] );
		} else if ( !strcmp( argv[i], "-tx" ) ) {
			_showTx = true;
		} else if ( !strcmp( argv[i], "-notx" ) ) {
			_showTx = false;
		} else if ( !strcmp( argv[i], "-txcolor" ) ) {
			_txColor.setNamedColor( argv[++i] );
		} else {
			if ( strcmp( argv[i], "-h" ) ) {
				fprintf( stderr, "%s: unrecognized option '%s'\n", argv[0], argv[i] );
			}
			fprintf( stderr, "Available options:\n" );
			fprintf( stderr, "-cmd ppp_cmd    The command to bring up the PPP link.\n" );
			fprintf( stderr, "-d n            Horizontal divider spacing in bytes per second (default: %d).\n", divider() );
			fprintf( stderr, "-h              Print this help.\n" );
			fprintf( stderr, "-i interval     Set the polling interval to be 'interval' seconds (default: %d).\n", interval() );
			fprintf( stderr, "-link link      The PPP link number to monitor (default: %d).\n", link() );
			fprintf( stderr, "-p period       Set the load averaging period to be 'period seconds (default: %d).\n", period() );
			fprintf( stderr, "-retry interval Time between retries when dialling PPP link (default: %d).\n", retry() );
			fprintf( stderr, "-rx             Enable drawing of receive statistics (default).\n" );
			fprintf( stderr, "-norx           Disable drawing of receive statistics.\n" );
			fprintf( stderr, "-rxcolor col    Set the receive color to be 'col' (default: red).\n" );
			fprintf( stderr, "-tx             Enable drawing of transmit statistics (default).\n" );
			fprintf( stderr, "-notx           Disable drawing of transmit statistics.\n" );
			fprintf( stderr, "-txcolor col    Set the transmit coloe to be 'col' (default: forestgreen).\n" );
			fprintf( stderr, "\n" );
			fprintf( stderr, "pppload version 1.0, Copyright (C) 1996 Sean Vyain\n" );
			fprintf( stderr, "pppload comes with ABSOLUTELY NO WARRANTY; for details see the LICENSE file.\n" );
			fprintf( stderr, "This is free software, and you are welcome to redistribute it\n" );
			fprintf( stderr, "under certain conditions; see the LICENSE file for details.\n" );

			exit( 1 );
		}
	}
}
