
#define MAXNUM_HELPLINES 222

static char *helpText[MAXNUM_HELPLINES] = {
" ",
"@t@b@m  User Interface General Information.",
" ",
"  When started, xisp displays a form with five buttons and two menus.",
"  Normally, in order to commence dialing, an ISP must be selected. The",
"  one selected by default right after startup is the first entry in the",
"  list of ISP's. The \"Quit\" button is always activated. The other",
"  button activated at this time is the \"Connect\" button. After a",
"  connection is initiated, and up until a PPP link is established,",
"  \"Connect\" is deactivated while \"Interrupt\" is activated. After a link",
"  is established, \"Interrupt\" is deactivated and \"Disconnect\" is",
"  activated. The fifth button labeled \"ARD\" indicates whether or not",
"  automatic redialing is desired for the selected ISP. When automatic",
"  redialing is indeed selected, if the PPP connection drops without the",
"  user explicitly pressing \"Disconnect\", redialing occurs. The \"Help\"",
"  menu selection is self explanatory, I guess :). The \"Options\" menu",
"  contains five items, \"ISP Selection\", \"Account Information\", \"Dialing",
"  and Login\", \"Communication Options\" and \"TCP/IP Options\".",
" ",
"@b  \"ISP Selection\"",
"     Brings up a list of ISP's to choose from. The first time xisp is",
"     executed all ISP names will be blank, as indicated by the '~'",
"     character (I wonder where I got that idea :)). One can edit the ISP",
"     name by marking the entry and then pressing \"Rename\", or double",
"     clicking on the entry. Pressing \"OK\" returns you to the main",
"     program window and sets your selection as the current ISP.",
" ",
"@b  \"Account Information\"",
"     Brings up a window with five input fields, and a set of four radio",
"     buttons. The first input field contains the list of phone numbers",
"     to dial for the selected ISP, the second is the user account name",
"     to use, and the third is the password. The radio buttons enable the",
"     use of password authentication using PAP, PAP using pap-secrets and",
"     CHAP using chap-secrets. The fourth input field contains the",
"     argument to the 'user' or 'name' argument to pppd, and the fifth",
"     contains the argument to the 'remotename' pppd argument. Note here",
"     that when any one of three available authentication methods is",
"     selected, the manual login option or any user script lines entered",
"     via the \"Dialing and Login\" menu, are ignored. In the phone number",
"     input field, more than one telephone numbers, and up to a total of",
"     8 can be entered by separating them with the semicolon (';')",
"     character. The total length of each phone number is currently",
"     limited to 32 characters.  A brief note on password security is in",
"     order here. The plaintext password entered in the \"Password\" input",
"     field is encoded using encrypt(3) with a key saved in the xisp",
"     executable. This key is itself scrambled so that it is not visible",
"     in the xisp binary. Since any one having access to the source can",
"     eventually come up with the key used and potentially decode users'",
"     .xisprc entries yielding the plaintext ISP passwords, system",
"     administrators installing xisp are urged to change the key employed.",
"     For more details, read the SECURITY file included with the xisp",
"     distribution.",
" ",
"@b  \"Dialing and Login\"",
"     Brings up a window with fields for entering the three dialing",
"     parameters, namely the number of dialing tries, the inter-dialing",
"     delay and the maximum time to wait for modem connection, as well",
"     as up to eight user customizable script lines. It also enables the",
"     launching of a manual login window after a connection is",
"     established, or enables ISP server call-back and editing of up to",
"     eight user customizable call-back script lines.  The first three",
"     input fields are pretty straight forward, and default values for",
"     all are suggested. The sub-form for editing the call-back script is",
"     activated by pressing the \"Options\" button. This form also includes",
"     a field for entering the time to wait for the call-back connection.",
"     The script section, both for dial-in and call-back, is divided into",
"     \"Expect:\" and \"Send:\" sections, as used by the call to the chat(8)",
"     command. Here the user must enter the script lines employed by chat",
"     to successfully negotiate a login for the particular ISP. Dial-in",
"     and call-back lines are not used when manual login or authenticated",
"     (PAP/PAP-S/CHAP-S) login is selected. For detailed script-line",
"     syntax and various examples please read the chat(8) manual page.",
"     The following simple example should give you an idea. Let us assume",
"     that the ISP of interest employs a terminal server which prompts",
"     the user with 'Username:', then with 'password:' and then gives the",
"     server prompt, a single '>', at which point the user must type",
"     'ppp' and press enter. The user customizable expect-send pairs for",
"     the above procedure would be:",
" ",
"         Expect:		Send:",
" ",
"         ername:--ername:	%s",
"         ssword:		%s",
"         >-->		ppp",
" ",
"     Note the two \"%s\"'s in the script lines. The first one is (quite",
"     obviously) replaced by your user account name (by the xisp program",
"     when it creates the dialing environment file), and the second one",
"     by your password. A total of two \"%s\"'s can exist in your script",
"     lines. Entering more than two will make xisp print a message and",
"     abort the dial. The script employed by xispdial for the connection is",
"     the concatenation of its internal script, and the user customizable",
"     script lines entered via \"Dialing Data\". The internal script used",
"     is the following:",
" ",
"         TIMEOUT		3",
"         ABORT		BUSY",
"         ABORT		'NO CARRIER'",
"         ABORT		enied",
"         ABORT		imeout",
"         ''			'AT D<dialing method> <the phone number>'",
"         TIMEOUT		<maximum wait for connection>",
"         CONNECT		''",
"         TIMEOUT		5",
"         \\r			''",
" ",
"     As seen above, the timeout value after connection is set to 5 seconds.",
"     If for some reason it takes more than that to log into a system, one",
"     could specify a new timeout value in the user script lines. For",
"     instance, in the example given above , if it takes 6 seconds for a",
"     prompt from the terminal server in question, the user customizable",
"     expect-send pairs could be:",
" ",
"         Expect:		Send:",
" ",
"         ername:--ername:	%s",
"         ssword:		%s",
"         TIMEOUT		10",
"         >-->		ppp",
" ",
"     allowing 10 (6 + an extra 4) seconds for receiving the '>' character.",
"     Important \"inside\" note: xispdial architecture is such that the script",
"     lines passed from xisp are used as part of a printf(3) function format.",
"     Thus, any non regular characters you need to pass to chat must be",
"     escaped by preceding them with the '\' character. Furthermore,",
"     following printf(3) syntax, the '%' special character is passed as",
"     '%%'. As an example, if you want to pass chat a carriage return",
"     character \r, you would have to enter it as \\r in the xisp script",
"     line. Note that since version 1.9 of xisp, when the script lines were",
"     divided into \"Expect:\" and \"Send:\" sections, you no longer need to",
"     enclose commands including spaces with single quotes. As an example,",
"     if at the end of the login session you start PPP using \"ppp /compress\",",
"     in versions prior to 1.9 you would need to enclose the command in",
"     single quotes and enter your script line as \">--> 'ppp /compress'\" in",
"     the above example. For versions 1.9 and later this is not necessary,",
"     as expect-send pairs are automatically quoted before being passed on",
"     to chat.  If call-back is selected, the following script is appended",
"     to the concatenation of user customizable script lines and modified",
"     internal script:",
" ",
"         TIMEOUT		<delay for call-back connection>",
"         CONNECT		''",
"         TIMEOUT		5",
"         \\r			''",
" ",
"     And following that, the user call-back script lines are appended to it.",
"     This instructs chat to wait the user-specified delay time for a second",
"     connect from the server as it dials back, and then to use the login",
"     procedure described in the call-back script. The dial-in internal",
"     script is modified by deleting the",
" ",
"         ABORT		'NO CARRIER'",
" ",
"     clause, since the carrier drops when the remote side hangs-up prior to",
"     calling back.",
" ",
"@b  \"Communication Options\"",
"     Brings up a window with six input fields and five sets of radio",
"     buttons. The \"Device\" input field is for selecting the special",
"     device file referring to the modem port, /dev/modem being the",
"     default. The input field named \"Reset\" contains the modem reset",
"     string, while that named \"Init\" enables customization of the",
"     modem initialization string. The default reset string is \"ATZ\"",
"     which should work with most modems. The default init string is a",
"     simple \"AT\" command. Note that xispdial appends an \"H0\" to the user",
"     defined initialization string. The sets of radio buttons enable",
"     selection of modem port (i.e. DCE<->DTE interface) speed, port flow",
"     control used (hardware or software), dialing mode (tone or pulse)",
"     and BSD software compression. The \"Level\" input field is the",
"     transmit and receive compression level as explained in the pppd(8)",
"     manual page, having a default value of 12. Note, however, that the",
"     PPP employed has to have BSD compression support for this option",
"     to have any effect, which for Linux happens only if you build PPP",
"     support as a kernel module. The last two input fields enable",
"     selection of the asyncmap and escape options provided by pppd; see",
"     the pppd(8) manual page for details on their function. The vast",
"     majority of dialup setups won't need the escape parameter, and that",
"     is the reason why it is off by default. The value of asyncmap, on",
"     the other hand, is automatically adjusted by your selection of flow",
"     control, i.e. whenever you change flow control type, the default",
"     value for asyncmap is inserted in the input field. Although the two",
"     default values should be adequate for general use, you can modify",
"     them further, to suit your needs.",
" ",
"@b  \"TCP/IP Options\"",
"     Brings up a window with seven input fields and four sets of radio",
"     buttons. With the exception of the primary and secondary DNS server",
"     entries, all remaining fields in this form are options which should",
"     only be changed if you understand their function; the default values",
"     are what you would need for your typical ISP connection. Please",
"     refer to the pppd(8) manual page for reading details on the function",
"     of these parameters, when you need to change their values. The last",
"     set of radio buttons enables support of the ip-up and ip-down",
"     scripts, allowing  the user to enter IP addresses for a primary and",
"     (possibly) a secondary DNS server. The ip-up and ip-down scripts",
"     normally reside in /etc/ppp, and are automatically invoked by pppd",
"     when the link is set-up and torn-down respectively. Enabling this",
"     option will instruct xisp to do two things. Firstly, to call pppd",
"     with the extra option 'ipparam', passing a string as a sixth",
"     argument to ip-up and ip-down; this string contains the name of the",
"     pipe node from which xisp reads xispdial output, the description",
"     string entered in the \"ISP Selection\" menu item, and the primary",
"     (and possibly secondary) DNS server IP addresses entered via the",
"     corresponding input fields. Secondly, to read extra input from the",
"     named pipe node, after xispdial terminates, effectively writing any",
"     output from ip-up and ip-down to the xisp browser. The ip-up and",
"     ip-down scripts provided with xisp, must be installed in /etc/ppp",
"     for the xisp DNS settings to have any effect. Both ip-up and",
"     ip-down include user customizable sections for performing tasks",
"     like, for example, downloading mail or news, on a per ISP basis.",
" ",
"  The program main window includes four connection indicators. The \"IP\"",
"  indicator prints the IP address assigned to you after successfully",
"  establishing a PPP link. The \"Status\" indicator is self explanatory I",
"  guess :). The \"Speed\" indicator prints the speed as returned by the",
"  modem \"CONNECT\" message, and the \"Connect Time\" indicator measures",
"  your connection time with a resolution of five seconds. The measured",
"  time will remain there after disconnection, until a new dialing",
"  sequence is initiated. The IP address can be selected for later pasting",
"  in some other window, by clicking the left mouse button on the IP readout",
"  Clicking again deselects it.",
" "
};

