// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C" {
#include <stdio.h>
}
#include "History.h"
#include "Options.h"

#include <qmenubar.h>

History::History( QPopupMenu* menu )
        : _menu( menu )
{
    updateMenu();
}

History::~History()
{
}

const Url* History::current()
{
    return _urls.current();
}

const Url* History::home()
{
//    printf( "History::home() -- homeUrl = '%s'\n", (const char*)options->homeUrl() );
    return open( options->homeUrl() );
}

const Url* History::back()
{
    _urls.prev();
    _titles.prev();
    emit canGoBack( _urls.at() > 0 );
    emit canGoForward( _urls.at() < ( int( _urls.count() ) - 1 ) );
//    printf( "History::back() -- url = '%s'\n", (const char*)_urls.current()->url() );
    return _urls.current();
}

const Url* History::forward()
{
    _urls.next();
    _titles.next();
    emit canGoBack( _urls.at() > 0 );
    emit canGoForward( _urls.at() < ( int( _urls.count() ) - 1 ) );
//    printf( "History::forward() -- url = '%s'\n", (const char*)_urls.current()->url() );
    return _urls.current();
}

const Url* History::open( const Url& url )
{
    int index = _urls.at() + 1;
    
    while ( int( _urls.count() ) > index ) {
        _urls.removeLast();
        _titles.removeLast();
    }

    _urls.append( new Url( url ) );
    _titles.append( new QString( url.url() ) );
    emit canGoBack( _urls.at() > 0 );
    emit canGoForward( _urls.at() < ( int( _urls.count() ) - 1 ) );
//    printf( "History::open() -- url = '%s'\n", (const char*)_urls.current()->url() );
    updateMenu();
    return _urls.current();
}

const Url* History::go( int index )
{
    index = _urls.count() - index - 1;
    _urls.at( index );
    _titles.at( index );
    emit canGoBack( _urls.at() > 0 );
    emit canGoForward( _urls.at() < ( int( _urls.count() ) - 1 ) );
//    printf( "History::go() -- url = '%s'\n", (const char*)_urls.current()->url() );
    return _urls.current();
}

void History::setTitle( QString title )
{
    if ( _titles.current() ) {
        *_titles.current() = title.copy();
        updateMenu();
    }
}

void History::updateMenu()
{
    // Remove the history entries.
    while ( _menu->count() > 4 ) {
        _menu->removeItemAt( 4 );
    }
    
    int index = _urls.at();
    for ( _urls.last(), _titles.last(); _urls.current() && _titles.current(); _urls.prev(), _titles.prev() ) {
        if ( _titles.current()->isNull() || _titles.current()->isEmpty() ) {
            _menu->insertItem( _urls.current()->url() );
        } else {
            _menu->insertItem( *_titles.current() );
        }
    }
    _urls.at( index );
    _titles.at( index );
}
