// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _StyleEditor_h_
#define _StyleEditor_h_

#include <qlist.h>
#include <qwidget.h>
#include "StyleSheetManager.h"

class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QListBox;
class QMenuBar;
class QPopupMenu;
class QPushButton;
class ScrolledWindow;
class SgmlAttrListBox;
class Style;
class StyleAttr;
class StyleAttrProto;
class StyleListBox;
class StyleSheet;

//: The StyleEditor class allows the user to directly edit a style sheet.
class StyleEditor : public QWidget,
                    public StyleSheetReceiver
{
    Q_OBJECT
public:
    class AttrInput : public QWidget {
        QLabel*         _label;
        StyleAttrProto* _proto;
        Style*          _style;
    protected:
        virtual void resizeEvent( QResizeEvent* e );
    public:
        AttrInput( QWidget* parent, StyleAttrProto* proto, Style* style );

        StyleAttrProto* proto() { return _proto; }

        Style* style() { return _style; }

        virtual QWidget* widget() = 0;

        virtual StyleAttr* apply() = 0;
    };

    class StringInput : public AttrInput {
        QLineEdit* _entry;
    public:
        StringInput( QWidget* parent, StyleAttrProto* proto, Style* style );

        QWidget* widget();

        StyleAttr* apply();
    };

    class NumberInput : public AttrInput {
        QLineEdit* _entry;
    public:
        NumberInput( QWidget* parent, StyleAttrProto* proto, Style* style );

        QWidget* widget();

        StyleAttr* apply();
    };

    class EnumeratedInput : public AttrInput {
        QComboBox* _combo;
    public:
        EnumeratedInput( QWidget* parent, StyleAttrProto* proto, Style* style );

        QWidget* widget();

        StyleAttr* apply();
    };

    class ListInput : public AttrInput {
        QComboBox* _combo;
    public:
        ListInput( QWidget* parent, StyleAttrProto* proto, Style* style );

        QWidget* widget();

        StyleAttr* apply();
    };

    class FlagInput : public AttrInput {
        QCheckBox* _check;
    public:
        FlagInput( QWidget* parent, StyleAttrProto* proto, Style* style );

        QWidget* widget();

        StyleAttr* apply();
    };
private:
    QMenuBar*        _menu;
    QPopupMenu*      _fileMenu;
    QLabel*          _fileNameLabel;
    QLabel*          _fileNameValue;
    QGroupBox*       _styleListGroup;
    StyleListBox*    _styleList;
    QGroupBox*       _styleSelectorGroup;
    QLabel*          _tagLabel;
    QLineEdit*       _tagEntry;
    QGroupBox*       _sgmlAttrsGroup;
    SgmlAttrListBox* _sgmlAttrsList;
    QLineEdit*       _attrNameEntry;
    QLabel*          _equalLabel;
    QLineEdit*       _attrValueEntry;
    QPushButton*     _sgmlAttrAddButton;
    QPushButton*     _sgmlAttrUpdateButton;
    QPushButton*     _sgmlAttrDeleteButton;
    QGroupBox*       _styleAttrsGroup;
    QLabel*          _displayLabel;
    QComboBox*       _displayCombo;
    ScrolledWindow*  _styleAttrsWindow;
    QWidget*         _styleAttrs;
    QPushButton*     _addButton;
    QPushButton*     _updateButton;
    QPushButton*     _deleteButton;

    StyleSheet*      _styleSheet;
    QList<AttrInput> _attrInputs;
    QString          _fileName;
    bool             _modified;

    int              _lastSgmlAttrIndex;

    void setFileName( const char* fileName );

    void setStyleSheet( StyleSheet* styleSheet );

    void constrain();
protected:
    //. Reposition my widgets.
    void resizeEvent( QResizeEvent* e );

    void closeEvent( QCloseEvent* e );
public:
    //: Create a new StyleEditor.  Create a StyleNotebook as a child widget,
    //. and connect it to my done() slot.
    StyleEditor( QWidget* parent=0, const char* name=0 );

    ~StyleEditor();

    void styleSheet( StyleSheet* styleSheet );
public slots:
    void fileNew();

    void fileOpen();

    bool fileSave();

    bool fileSaveAs();

    bool fileClose();

    void fileDismiss();

    void styleHighlighted( int index );

    void sgmlAttrHighlighted( int index );

    void sgmlAttrAdd();

    void sgmlAttrUpdate();

    void sgmlAttrDelete();

    void styleAdd();

    void styleUpdate();

    void styleDelete();

    void displayActivated( int index );
};

extern StyleEditor* styleEditor;

#endif
