// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _StyleSelect_h_
#define _StyleSelect_h_

#include <qdialog.h>
#include "StyleSheetManager.h"

class Dtd;
class QListBox;
class QPushButton;

//: The StyleSelect class provides a dialog for choosing a style sheet.
//. If a style sheet is selected, the DtdManager is sent a request for the
//. corresponding DTD.  When the DTD is ready, the dialog hide()s. and the
//. DTD can be retrieved by the caller.
class StyleSelect : public QDialog,
                    public StyleSheetReceiver
{
    Q_OBJECT
    StyleSheet*  _styleSheet;
    QListBox*    _list;
    QPushButton* _okButton;
    QPushButton* _cancelButton;
protected:
    //. Reposition my widgets.
    virtual void resizeEvent( QResizeEvent* e );
public:
    StyleSelect( QWidget* parent=0, const char* name=0 );
    ~StyleSelect();

    //. Return the Style Sheet that was selected.
    StyleSheet* getStyleSheet() { return _styleSheet; }

    void styleSheet( StyleSheet* styleSheet );
public slots:
    //. Retrieve the selected style sheet, and close this dialog.
    void ok();

    //. A row in the listbox has been double-clicked.  Retrieve the selected
    //. style sheet, and close this dialog.
    void selected( int index );
};

#endif
