/*
 * The #defines for tokens can be overridden by a -DTokDotH=... compiler
 *  option. This specifies a file containing token #defines and is useful
 *  for creating an embedded preprocessor where token definitions are
 *  generated by yacc from a grammar.
 *
 * Otherwise, the default token definitions are RTT's; if NoRTT is
 *  defined, then this file's definitions are used.
 */
#ifdef TokDotH
#include TokDotH
#else					/* TokDotH */
#ifndef NoRTT
#include "../rtt/ltoken.h"
#else					/* RTT */
/*
 * These are the numbers for tokens (other than single characters) returned
 *   by the preproccesor and seen by a yacc parser for a C grammar.
 */
#define And 257
#define AndAsgn 258
#define Arrow 259
#define CharConst 260
#define Decr 261
#define DivAsgn 262
#define Ellipsis 263
#define Equal 264
#define Geq 265
#define Identifier 266
#define Incr 267
#define LCharConst 268
#define LShft 269
#define LShftAsgn 270
#define LStrLit 271
#define Leq 272
#define MinusAsgn 273
#define ModAsgn 274
#define MultAsgn 275
#define Neq 276
#define Or 277
#define OrAsgn 278
#define PlusAsgn 279
#define RShft 280
#define RShftAsgn 281
#define StrLit 282
#define XorAsgn 283
#endif					/* NoRTT */
#endif					/* TokDotH */
