#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/codegen/support.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.10
 | File mod date:    1997.11.29 23:10:33
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  codegen
 |
 | Purpose:          bytecode code generator support library
 `------------------------------------------------------------------------|#

;; bytecode code generator support library

;;

(define *current-pc* 0)
(define *current-buffer* #f)
(define *patch-table* '())
(define *label-table* '())

(define *debug-byte-codes* #f)

(define (emit-byte-code b)
  (if *debug-byte-codes*
      (format #t "[~d] bytecode ~d\n" *current-pc* b))
  (bvec-set! *current-buffer* *current-pc* b)
  (set! *current-pc* (+ 1 *current-pc*)))

(define (emit-byte-code-check b)
    (assert (and (fixnum? b)
    	         (>= b 0)
		 (< b 256)))
    (emit-byte-code b))

(define (emit-byte-code-16-check b)
    (assert (and (fixnum? b)
    	         (>= b 0)
		 (< b 65536)))
    (emit-byte-code (logical-shift-right b 8))
    (emit-byte-code (bitwise-and b #xFF)))

(define (emit-byte-code-s16-check b)
    (assert (and (fixnum? b)
    	         (>= b -32768)
		 (< b 32768)))
    (emit-byte-code (bitwise-and (logical-shift-right b 8) #xFF))
    (emit-byte-code (bitwise-and b #xFF)))

(define (emit-byte-code-s32 b)
    (emit-byte-code (bitwise-and (logical-shift-right b 24) #xFF))
    (emit-byte-code (bitwise-and (logical-shift-right b 16) #xFF))
    (emit-byte-code (bitwise-and (logical-shift-right b 8) #xFF))
    (emit-byte-code (bitwise-and b #xFF)))

(define (emit-primop primop-bdg num-args)
  (let ((b (assq 'bytecode (translations (actual-bdg primop-bdg)))))
    (if b
	(let ((op (cdr b)))
	  (if (pair? op)
	      ;; extension primop
	      (begin
		(emit-byte-code 254)
		(emit-byte-code-check (car op))
		(emit-byte-code-check (cdr op)))
	      (if (symbol? op)
		  ;; special primop
		  (emit-special-primop op num-args)
		  ;; normal primop
		  (begin
		    (emit-byte-code 255)
		    (emit-byte-code-check op)))))
	(error/internal
	 "primop cannot be rendered in bytecode: ~s"
	 primop-bdg))))

(define (reset-byte-codes)
    (set! *label-table* '())
    (set! *patch-table* '())
    (set! *current-pc* 0)
    (if (not *current-buffer*)
	(set! *current-buffer* (bvec-alloc <byte-vector>
					   65500))))

(define (get-label label table)
  (let ((e (assq label table)))
    (if e
	(cdr e)
	(abort 'get-label
	       "label `~s' somehow not defined"
	       label))))

(define (flush-byte-codes)
    ;; patch up references to labels
    (for-each
	(lambda (p)
	    (let ((def (get-label (car p) *label-table*))
	    	  (i (cdr p)))
		(bvec-set! *current-buffer* i (logical-shift-right def 8))
		(bvec-set! *current-buffer* (+ i 1) (bitwise-and def #xFF))
		i))
	*patch-table*)
    (let ((bcp (bvec-alloc <byte-coded> *current-pc*)))
	(bvec-copy bcp 0 *current-buffer* 0 *current-pc*)
	bcp))


(define (def-label l)
  (if *debug-byte-codes*
      (format #t "[~d] definining label: ~s\n" *current-pc* l))
  (set! *label-table* (cons (cons l *current-pc*) *label-table*)))
    
(define (ref-label l)
  (if *debug-byte-codes*
      (format #t "[~d] referencing label: ~s\n" *current-pc* l))
  (set! *patch-table* (cons (cons l *current-pc*) *patch-table*))
  ;; return 0 to be inserted into bc stream for now
  0)

(define (aml->byte-coded aml)
  (if *debug-byte-codes*
      (begin
	(display (make-string 60 #\-))
	(newline)))
  (reset-byte-codes)
  (for-each compile-aml-stmt aml)
  (flush-byte-codes))

(define-syntax (kget table key)
  (let ((e (table-lookup table key)))
    (if e
	e
	(abort 'kget "key `~s' not in table `~s'" key (mquote table)))))
