#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/highscm/promise.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:32
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  high-scheme
 |
 | Purpose:          delay and force
 `------------------------------------------------------------------------|#

(define-class <promise> (<object>)
  compute-using
  (computed-value init-value: #f))

(define (force (promise <promise>))
  (let ((thunk (compute-using promise)))
    (if thunk
	(begin
	  (set-compute-using! promise #f)
	  (set-computed-value! promise (thunk))))
    (computed-value promise)))

(define-syntax (delay expr)
  (make <promise>
	compute-using: (lambda () expr)))

(define-method write-object ((self <promise>) port)
  (if (compute-using self)
      (format port "#[<promise>]")
      (format port "#[<promise> fulfilled]")))
