#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/paths/filesys.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.7
 | File mod date:    1997.11.29 23:10:37
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  paths
 |
 | Purpose:          User-level interface to the file system
 |------------------------------------------------------------------------|
 | Notes:
 |      These functions take <*-name> arguments and translate them
 |      for use by the underlying OS
 `------------------------------------------------------------------------|#

(define (file-exists? path)
  (os-file-exists? (pathname->os-path path)))

(define (chdir path)
  (os-setwd! path)
  ;; flush the "getwd" cache
  (set! *process-dir* #f)
  path)

(define (within-directory (dir <directory-name>) thunk)
  (fluid-let ((*current-dir* dir))
    (thunk)))
