#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/repl/ccbt.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.2
 | File mod date:    1997.11.29 23:10:32
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  repl
 |
 | Purpose:          continuation chain backtrace
 `------------------------------------------------------------------------|#

(define (partial-continuation? thing)
  (instance? thing <partial-continuation>))

(define *bci-addrs* #f)

(define (get-bci-addrs)
  (bind ((module-descr (find-linked-module "bci"))
	 (part-descr (find-part-in-linked-module module-descr 8902))
	 (entry fn-descr (find-code-ptr-in-part part-descr 0))
	 (name addrs (get-c-function-descr fn-descr)))
    addrs))

(define (partial-continuation-bci? (pc <partial-continuation>))
  (memq (pc-jump-addr pc) *bci-addrs*))

(define (pc-envt-reg pc)          (gvec-ref pc 0))
(define (pc-template-reg pc)      (gvec-ref pc 1))
(define (pc-jump-addr pc)         (gvec-ref pc 2))
(define (pc-continuation-reg pc)  (gvec-ref pc 3))

(define (pc-regs pc)
  (let loop ((i (gvec-length pc))
	     (r '()))
    (if (> i 4)
	(loop (sub1 i) (cons (gvec-ref pc (sub1 i)) r))
	r)))

;; llc is a <closure> whose binding envt
;; contains a partial cont

(define (ll->partial (llc <function>))
  (gvec-ref (environment llc) 1))

(define (print-bdg-envt frame-number frame)
  (let ((num-slots (sub1 (gvec-length frame))))
    (let loop ((slot 0))
      (if (< slot num-slots)
	  (begin
	    (format #t "     ~d:~d => " frame-number slot)
	    (display (object->bounded-string (current-display-limit) 
					     (gvec-ref frame (+ slot 1))))
	    (newline)
	    (loop (+ slot 1)))))))

(define (print-bdg-envt-chain frame-number frame)
  (if (instance? frame <binding-envt>)
      (begin
	(print-bdg-envt frame-number frame)
	(print-bdg-envt-chain (+ frame-number 1) (gvec-ref frame 0)))))

(define (print-1-pc (pc <partial-continuation>))
  (let ((r (pc-regs pc))
	(t (pc-template-reg pc))
	(e (pc-envt-reg pc)))
    (format #t "will continue at:\n")
    (format #t "    program counter: ")
    (if (partial-continuation-bci? pc)
	(begin
	  (format #t "~d  " (car r))
	  (set! r (cdr r)))
	(format #t "#x~04x~04x  "
		(obj-high-bits (pc-jump-addr pc))
		(obj-low-bits (pc-jump-addr pc))))
    (format #t "~a\n" (name t))
    (let reg-loop ((i 0) 
		   (r r))
      (if (pair? r)
	  (begin
	    (format #t "    REG~d => " i)
	    (display (object->bounded-string (current-display-limit) (car r)))
	    (newline)
	    (reg-loop (+ i 1) (cdr r)))
	  (if (not (null? e))
	      (if (instance? e <binding-envt>)
		  (begin
		    (format #t "    in binding environment:\n")
		    (print-bdg-envt-chain 0 e))
		  (format #t "    in: ~s\n" e)))))))

(define-method print ((self <partial-continuation>))
  (let loop ((pc self))
    (if (partial-continuation? pc)
	(begin
	  (print-1-pc pc)
	  (loop (pc-continuation-reg pc)))
	self)))

(define (ccbt)
  (set! *bci-addrs* (get-bci-addrs))
  (low-level-call/cc
   (lambda (ll-continuation)
     (print (ll->partial ll-continuation))))
  (values))

(define (show-bt envt) 
  (ccbt))

