// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLEventManager.h

  Stephane Rehel
  June 29, 1996
*/

#ifndef __MLEventManager_h
#define __MLEventManager_h

#ifndef __IBOOL_h
#include "tools/IBOOL.h"
#endif

#ifndef __SIList_h
#include "tools/SIList.h"
#endif

#ifndef __MLEvent_h
#include "MLEvent.h"
#endif

class MLEvent;
class MLWindow;
class SystemWindow;

class MLKeyboardHandler;
class MLEventGrabber;

/////////////////////////////////////////////////////////////////////////////

class MLEventManager
{
private:
  static MLEventManager* eventManager; // THE event manager

protected:
  SIList<MLEvent> events;
  MLKeyboardHandler* keyboardFocus;
  MLEventGrabber* eventGrabber;

  // time out in seconds
  double wait_time_out;

public:
  MLEventManager();
  virtual ~MLEventManager();

  static MLEventManager* getEventManager()
    {
    return eventManager;
    }

  // focus may be NULL for no special focus
  // return previous one
  MLKeyboardHandler* setKeyboardFocus( MLKeyboardHandler* _keyboardFocus );

  // grabber may be NULL for ungrabbing
  // return previous one
  MLEventGrabber* setEventGrabber( MLEventGrabber* _eventGrabber );

  IBOOL empty() const
    {
    return events.empty();
    }

  void setWaitTimeout( double wto );

  // wait for events and get them
  // returns if no event after wait_time_out seconds
  // return IFALSE if timed out
  virtual IBOOL wait() = 0;

  // get events and return
  virtual void get() = 0;

  // Called by any thread for unblocking the main thread
//  virtual void unblockWaiting() = 0;

  IBOOL dispatch( IBOOL only_one = IFALSE );

  void destroyWindow( MLWindow* window );

  void removeEvents( MLWindow* window );

  // return ITRUE if found any
  IBOOL removeTyped( MLWindow* window, MLEvent::Type eventType );

  IBOOL findTyped( MLWindow* window, MLEvent::Type eventType );

  MLEvent* getTyped( MLWindow* window, MLEvent::Type eventType );

  void postEvent( MLEvent* event, IBOOL ignore_unmapped = IFALSE );

  void removeRedraw( SystemWindow* window );

  void removeAnyRedraw();

  IBOOL sendEvent( MLWindow* window, MLEvent& event,
                   IBOOL with_grab = ITRUE );

protected:
  IBOOL dispatchEvent( MLWindow* window, MLEvent& event );

  SIList<SystemWindow>& getSystemChildren( SystemWindow* sw );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLEventManager_h

