// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoCanvas.C

  Stephane Rehel

  October 25 1997
*/

#include "tools/file/MLWFileBlock.h"
#include "tools/file/MLRFileBlock.h"

#include "PhotoCanvas.h"
#include "PhotoModule.h"

#include "engines/PTEColored.h"
#include "engines/PTERed.h"
#include "engines/PTEGreen.h"
#include "engines/PTEBlue.h"
#include "engines/PTEAlpha.h"

/////////////////////////////////////////////////////////////////////////////

PhotoCanvas::PhotoCanvas()
{
  coloredEngine= 0;
  redEngine= 0;
  greenEngine= 0;
  blueEngine= 0;
  alphaEngine= 0;
}

/////////////////////////////////////////////////////////////////////////////

PhotoCanvas::~PhotoCanvas()
{
  coloredEngine= 0;
  redEngine= 0;
  greenEngine= 0;
  blueEngine= 0;
  alphaEngine= 0;
}

/////////////////////////////////////////////////////////////////////////////

void PhotoCanvas::create( MLModule* _module, int _where )
{
  MLCanvas::create(_module,_where);

  coloredEngine= new PTEColored(this);
  coloredEngine->updatePopupsFlags();

  redEngine= new PTERed(this);
  redEngine->updatePopupsFlags();

  greenEngine= new PTEGreen(this);
  greenEngine->updatePopupsFlags();

  blueEngine= new PTEBlue(this);
  blueEngine->updatePopupsFlags();

  alphaEngine= new PTEAlpha(this);
  alphaEngine->updatePopupsFlags();

  MLCanvas::addEngine( coloredEngine );
  MLCanvas::addEngine( redEngine );
  MLCanvas::addEngine( greenEngine );
  MLCanvas::addEngine( blueEngine );
  MLCanvas::addEngine( alphaEngine );

  activateDefaultEngine();
}

/////////////////////////////////////////////////////////////////////////////

void PhotoCanvas::refreshScreen( unsigned what )
{
  if( MLCanvas::engine == 0 )
    return;

  ((PhotoEngine*)MLCanvas::engine)->refreshScreen(what);
}

/////////////////////////////////////////////////////////////////////////////

void PhotoCanvas::write( MLWFileBlock& block )
{
  MLCanvas::write(block);
  block << int(0);
}

/////////////////////////////////////////////////////////////////////////////

void PhotoCanvas::read( MLRFileBlock& block )
{
  MLCanvas::read(block);
  if( block.getInteger() == 0 )
    return;
}

/////////////////////////////////////////////////////////////////////////////

void PhotoCanvas::activateDefaultEngine()
{
  int index= ((PhotoModule*)module)->getCanvasIndex(this);

  switch( index )
    {
    case 1: MLCanvas::activateEngine( redEngine->getID() );
            break;
    case 2: MLCanvas::activateEngine( coloredEngine->getID() );
            break;
    case 3: MLCanvas::activateEngine( blueEngine->getID() );
            break;
    case 4: MLCanvas::activateEngine( greenEngine->getID() );
            break;
    default:
      break;
    }
}

/////////////////////////////////////////////////////////////////////////////

void PhotoCanvas::resetAll()
{
  MLCanvas::resetAll();

  activateDefaultEngine();
}

/////////////////////////////////////////////////////////////////////////////
