// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PTEColored.h

  Stephane Rehel

  October 25 1997
*/

#ifndef __PTEColored_h
#define __PTEColored_h

#ifndef __IVector_h
#include "tools/IVector.h"
#endif

#ifndef __PhotoEngine_h
#include "photo/PhotoEngine.h"
#endif

class MLCanvasPopup;
class MLCanvasButton;
class PhotoCanvas;
class MLEvent;
class MLXORRectAction;
class PhotoCommand;
class Photo;

/////////////////////////////////////////////////////////////////////////////

class PTEColored: public PhotoEngine
{
protected:
  int x, y;

  struct
    {
    float red, green, blue, alpha;
    } scale;

  struct
    {
    float red, green, blue, alpha;
    } bias;
  float pixelZoom;

  MLCanvasButton* displayTypeButton;

  MLCanvasPopup* optionsPopup;

  int options_popup_wire_front;

public:
  PTEColored( PhotoCanvas* _canvas );

  virtual ~PTEColored();

protected:
  // convert screen coordinates to image coordinates
  IPoint screen_to_image( const IPoint& p );

  // return IFALSE if window is unmapped, etc.
  void draw_photo( Photo* photo );

public:
  virtual void draw();

  virtual void refreshScreen( unsigned what );

  virtual void leaveMode( MLMode* mm );

protected:
  virtual IBOOL handleAction( MLAction* action );

  virtual void write( MLWFileBlock& block );
  virtual void read( MLRFileBlock& block );

  virtual void resetAll();

public:
  virtual void updatePopupsFlags();
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __PTEColored_h
