// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   MLSVertex.h

   November 10 1996
   Stephane Rehel
*/

#ifndef __MLSVertex_h
#define __MLSVertex_h

#ifndef __Vector_h
#include "tools/Vector.h"
#endif

#ifndef __Vector2_h
#include "tools/Vector2.h"
#endif

struct MeshRep;

/////////////////////////////////////////////////////////////////////////////

struct MLSVertex
{
  int vertex; // base vertex, refinement vertex
//  int ref_polygon; // only if vertex is a discontinuity vertex, this is
                   // the polygon associated to the discontinuity
                   // SVertex

  Vector normal;

  int material;
  Vector2 txtCoord;

  typedef unsigned int Flag;
  Flag flags;

  enum FLAG
    {
    ALLOCATED    = (1<<0),
    BASE_SVERTEX = (1<<1),
    REFINEMENT   = (1<<2), // refinement SVertex
    TMP_FLAG     = (1<<3)
    };

  int allocated() const
    {
    return (flags & Flag(ALLOCATED)) != Flag(0);
    }

  MLSVertex()
    {
    vertex= 0;
//    ref_polygon= 0;
    flags= Flag(ALLOCATED);
    }

  ~MLSVertex()
    {
    vertex= 0;
//    ref_polygon= 0;
    flags&= ~Flag(ALLOCATED);
    }

  int getSizeOf() const;

  void updateNormal( MeshRep* mesh );

  void gob( const MLSVertex& sv );

  void unallocate();
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLSVertex_h
