// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  FormalText.C

  Stephane Rehel

  February 8 1998
*/

#include "tools/file/MLRFileBlock.h"
#include "tools/file/MLWFileBlock.h"

#include "FormalText.h"

#include "MLTextGenerate.h"
#include "FTEngine.h"
#include "FTFace.h"
#include "GLTTFont.h"

/////////////////////////////////////////////////////////////////////////////

FormalText::FormalText()
{
  text= "Moonlight";
  ttf_name= "arial";
  precision= 4.;
}

/////////////////////////////////////////////////////////////////////////////

FormalText::~FormalText()
{}

/////////////////////////////////////////////////////////////////////////////

int FormalText::getSizeOf() const
{
  int s= FormalRep::getSizeOf();

  s += sizeof(text) + text.length();

  return s;
}

/////////////////////////////////////////////////////////////////////////////

FormalRep::TYPE FormalText::getType() const
{
  return FormalRep::TEXT;
}

/////////////////////////////////////////////////////////////////////////////

void FormalText::generate( MeshRep* mesh ) const
{
  if( mesh == 0 )
    return;

  FTEngine engine;
  if( ! engine.init() )
    return;

  FTFace face;
  if( ! face.open("/dos/win/fonts/arial.ttf") )
    return;

  GLTTFont font(&face);

  font.setPrecision(precision);

  int point_size= 100;
  if( ! font.create(point_size) )
    return;

  MLTextGenerate g;

//  IBOOL outcome=
  g.generate( mesh, text, font, precision );

}

/////////////////////////////////////////////////////////////////////////////

FormalRep* FormalText::duplicate()
{
  FormalText* f= new FormalText;

  f->text= text;
  f->ttf_name= ttf_name;
  f->precision= precision;

  return f;
}

/////////////////////////////////////////////////////////////////////////////

void FormalText::_read( MLRFileBlock* block )
{
  *block >> text;
  *block >> ttf_name;
  precision= block->getDouble();
}

/////////////////////////////////////////////////////////////////////////////

void FormalText::_write( MLWFileBlock* block )
{
  *block << text;
  *block << ttf_name;
  *block << double(precision);
}

/////////////////////////////////////////////////////////////////////////////
