/* BeroList WWW Gateway              */
/* Display list of archived messages */

#include "list.h"
#include "tool.h"
#include "cgitool.h"
#include "cgipath.h"
#include <gdbm.h>

void errhead()
{
		html_head("Server configuration error");
		puts("<H1>Server configuration error</H1><HR>");
}

int main(int argc, char *argv[])
{
	char *listname, *configfile, *config, *archivefile;
	char *d_key, *s;
	char *subject, *from, *msgdat;
	GDBM_FILE db;
	datum key,content;
	unsigned int num,function=0;
	register unsigned int i;
	
	listname=cgi_scan("list"); 
	if(listname==NULL) {
		errhead();
		puts("The BeroList message list script is not configured correctly.<BR>");
		puts("You have to specify the parameter list=listname.");
		exit(1);
	}
	if(scasecmp(cgi_scan("function"),"edit")==0)
		function=1;
	configfile=salloc(slen(LISTDIR)+slen(listname)+9);
	sprintf(configfile,"%s/%s.config",LISTDIR,listname);
	config=readfile(configfile);
	if(config==NULL) {
		errhead();
		printf("The specified list, %s, does not exist.",listname);
		exit(1);
	}
	if(function==1) {
		if(extract(config,"www-password=",'\n')==NULL) {
			errhead();
			puts("This list is not configured for WWW administration.");
			exit(1);
		} else if(scmp(extract(config,"www-password=",'\n'),cgi_scan("pw"))!=0) {
			errhead();
			puts("Wrong password.");
			exit(1);
		}
	}
	archivefile=extract(config,"archive=",'\n');
	if(archivefile==NULL) {
		archivefile=salloc(slen(LISTDIR)+slen(listname)+10);
		sprintf(archivefile,"%s/%s.archive",LISTDIR,listname);
	}
	if(scasecmp(archivefile,"none")==0) {
		errhead();
		printf("The specified list, %s, does not archive messages.",listname);
		exit(1);
	}
	
	db=gdbm_open(archivefile,0,GDBM_READER,00664,0);
	if(db==NULL) {
		errhead();
		printf("Couldn't open archive file for list %s...<BR>Archive empty?",listname);
		exit(1);
	}

	html_head("BeroList messages");
	printf("<H1>Messages on list %s:</H1><BR>\n",listname);
	puts("<TABLE BORDER=0 WIDTH=100%>");
	puts("<TR><TD WIDTH=80%><B>Subject</B><TD><B>From</B><TD><B>Date/Time</B>");
	d_key=salloc(4);
	strcpy(d_key,"num");
	key.dptr=d_key;
	key.dsize=3;
	content=gdbm_fetch(db,key);
	free(d_key);
	num=atoi(content.dptr);
	s=salloc(12);
	for(i=0;i<num;i++) {
		sprintf(s,"s%u",i);
		key.dptr=s;
		key.dsize=slen(s);
		content=gdbm_fetch(db,key);
		subject=salloc(content.dsize+1);
		strncpy(subject,content.dptr,content.dsize);

		sprintf(s,"d%u",i);
		key.dptr=s;
		key.dsize=slen(s);
		content=gdbm_fetch(db,key);
		if(content.dptr==NULL) {
			msgdat=salloc(20);
			sprintf(msgdat,"(date/time unknown)");
		} else {
			msgdat=salloc(content.dsize+1);
			strncpy(msgdat,content.dptr,content.dsize);
		}

		sprintf(s,"f%u",i);
		key.dptr=s;
		key.dsize=slen(s);
		content=gdbm_fetch(db,key);
		from=salloc(content.dsize+1);
		strncpy(from,content.dptr,content.dsize);
		printf("<TR><TD>");
		printf("<A HREF=\"%s?list=%s&msg=%u\">%s</A>",DISPLAY_CGI,listname,i,subject);
		if(from!=NULL) printf("<TD><A HREF=mailto:%s>%s</A>",email(from),realname(from));
		          else printf("<TD><I>(not specified)</I>");
		          printf("<TD>%s",msgdat);
		if(function==1) {
			printf("<TD><A HREF=\"%s?list=%s&msg=%u&pw=%s&function=edit\">EDIT</A>",DISPLAY_CGI,listname,i,cgi_scan("pw"));
			printf("<TD><A HREF=\"%s?list=%s&msg=%u&pw=%s&function=delete\">DELETE</A>",EDIT_CGI,listname,i,cgi_scan("pw"));
		}
	} 
	printf("</TABLE><P><HR><ADDRESS><CENTER><A HREF=http://www.croftj.net/~bero/BeroList/>%s</A> - &copy; by <A HREF=mailto:bero@bero-online.ml.org>Bernhard Rosenkr&auml;nzer</A></ADDRESS>",VERSION);
	return 0;
}
