plot.cluster <- function(clobj, x, centers=TRUE, initcenters=TRUE,
                         color=rainbow(clobj$ncenters),...){

  
  x <- as.matrix(x)
  
  cl <- predict(clobj, x)

  
  if(dim(x)[2]>2){
    pairs(x, col=color[cl$cluster], ...)
    }
  else{
    plot(x, col=color[cl$cluster], ...)
    if(centers)
      points(cl$centers, pch="X",col=color)
    if(initcenters)
      points(cl$initcenters, pch="+",col=color)
  }
}



