\name{knn}
\alias{knn}
\title{
k-Nearest Neighbour Classification
}
\usage{
knn(train, test, class, k=1, l=1, prob=F, use.all=T)
}
\arguments{
\item{train}{
matrix or data frame of training set cases.
}
\item{test}{
matrix or data frame of test set cases. A vector will be interpreted
as a row vector for a single case.
}
\item{class}{
factor of true classifications of training set
}
\item{k}{
number of neighbours considered.
}
\item{l}{
minimum vote for definite decision, otherwise \code{doubt}. (More
precisely, less than \code{k-l} dissenting votes are allowed, even if \code{k}
is increased by ties.)
}
\item{prob}{
If this is true, the proportion of the votes for the winning class
are returned as attribute \code{prob}.
}
\item{use.all}{
controls handling of ties. If true, all distances equal to the \code{k}th
largest are included. If false, a random selection of distances
equal to the \code{k}th is chosen to use exactly \code{k} neighbours.
}}
\value{
factor of classifications of test set. \code{doubt} will be returned as \code{NA}.
}
\seealso{
\code{\link{knn1}}, \code{\link{knn.cv}}
}
\keyword{classif}
% Converted by Sd2Rd version 0.2-a4.
