\name{points.polynomial}
\title{Points Method for Polynomials}
\usage{
points(p, length = 100, \dots)
}
\arguments{
\item{p}{An object of class polynomial}
\item{length}{Size of x vector at which evaluations are to be made}
\item{\dots}{Additional arguments as for the points generic}
}
\description{
Add a polynomial to an existing plot usually as a point plot.

Points representing the given polynomial are added to an existing plot.
Values outside the current plot region are not shown.
}
\value{
As for the points generic.
}
\seealso{
plot, lines, points, plot.polynomial, lines.polynomial
}
\examples{
p <- poly.from.zeros(-1:5)
plot(p)
lines(poly.from.zeros(2:4), lty=2)
points(poly.from.zeros(-2:6), pch=4)
}
