"rat"<-
function(x, leng = 6, maxm = 100, name = "rational.so")
{
       if(!is.loaded(symbol.C("rational"))) {
	       library.dynam("rational", package = "rational")
       }
       hold <- attributes(x)
       i <- is.na(x)
       if(any(i))
               x[i] <- 0
       x <- as.double(x)
       storage.mode(x) <- "double"
       num <- den <- x
       h <- .C("rational",
               x,
               as.integer(length(x)),
               as.integer(leng),
               as.integer(maxm),
               num = num,
               den = den)
       if(any(i)) {
               h$den[i] <- NA
               h$num[i] <- NA
       }
       attributes(h$num) <- hold
       attributes(h$den) <- hold
       list(num = h$num, den = h$den)
}
"rational"<-
function(x, ...)
{
       y <- rat(x, ...)
       y$num/y$den
}
"fractions"<-
function(x, ...)
{
       hold <- attributes(x)
       y <- rat(x, ...)
       denc <- ifelse(y$den == 1, "", paste("/", y$den, sep = ""))
       y <- paste(y$num, denc, sep = "")
       attributes(y) <- hold
       y
}
