#include "defs.h"
#include <xview/file_chsr.h>



static Attr_attribute     MY_KEY;

/* Define external variables for window and panel handling */
extern   frame;

/* Define local Variables */
Frame    FileFrame;
Panel    BuildPanel;


File_chooser    p_openfile, p_savefile;

int   my_x_size, my_y_size;


extern int   dsp_width, dsp_height;



void FileOpenNotify();
void FileSaveNotify();



void FileOpen(filename)
char  *filename;
{
  if (!p_openfile) {
    p_openfile = (File_chooser) xv_create(frame, FILE_CHOOSER_OPEN_DIALOG,
				 XV_LABEL,   "Open file...",
				 XV_KEY_DATA,  MY_KEY, frame,
 				 FILE_CHOOSER_NOTIFY_FUNC, FileOpenNotify,
				 FILE_CHOOSER_DOC_NAME, filename,
				 NULL);

    my_x_size = (int) ((dsp_width - xv_get(p_openfile, XV_WIDTH)) / 2);
    my_y_size = (int) ((dsp_width - (xv_get(p_openfile, XV_HEIGHT) * 2)) + 30);

    xv_set(p_openfile, XV_X, my_x_size, XV_Y, my_y_size, NULL);

  } else {
    xv_set(p_openfile, FILE_CHOOSER_DOC_NAME, filename, NULL);
  }

  xv_set(p_openfile, XV_SHOW, TRUE, NULL);
}


void FileSave(filename)
char   *filename;
{
  if (!p_savefile) {
    p_savefile = (File_chooser) xv_create(frame, FILE_CHOOSER_SAVEAS_DIALOG,
				 XV_LABEL,   "Save file...",
				 XV_KEY_DATA,  MY_KEY, frame,
				 FILE_CHOOSER_NOTIFY_FUNC, FileSaveNotify,
				 FILE_CHOOSER_DOC_NAME,    filename,
				 NULL);

    my_x_size = (int) ((dsp_width - xv_get(p_savefile, XV_WIDTH)) / 2);
    my_y_size = (int) ((dsp_width - (xv_get(p_savefile, XV_HEIGHT) * 2)) + 30);

    xv_set(p_savefile, XV_X, my_x_size, XV_Y, my_y_size, NULL);
  } else {
    xv_set(p_savefile, FILE_CHOOSER_DOC_NAME, filename, NULL);
  }

  xv_set(p_savefile, XV_SHOW, TRUE, NULL);
}



void FileOpenNotify(fc, path, file, client_data)
File_chooser     fc;
char             *path;
char             *file;
Xv_opaque        client_data;
{
  fprintf(stderr, "Path: %s\n", path);
  fprintf(stderr, "File: %s\n", file);

  xv_set(p_openfile, XV_SHOW, FALSE, NULL);
}

void FileSaveNotify(fc, path, file, client_data)
File_chooser     fc;
char             *path;
char             *file;
Xv_opaque        client_data;
{
  fprintf(stderr, "Path: %s\n", path);
  fprintf(stderr, "File: %s\n", file);
  
  xv_set(p_savefile, XV_SHOW, FALSE, NULL);
}



