
/***

ifstats.h - structure definitions for interface counts
	
***/

struct iflist {
    char ifname[8];
    unsigned long iptotal;
    unsigned long badtotal;
    unsigned long noniptotal;
    unsigned long total;
    unsigned int spanbr;
    unsigned long br;
    float rate;
    float peakrate;
    unsigned int index;
    struct iflist *prev_entry;
    struct iflist *next_entry;
};

struct iftab {
    struct iflist *head;
    struct iflist *tail;
    struct iflist *firstvisible;
    struct iflist *lastvisible;
    WINDOW *borderwin;
    PANEL *borderpanel;
    WINDOW *statwin;
    PANEL *statpanel;
};

struct iftotals {
    unsigned long total;
    unsigned long bytestotal;
    unsigned long iptotal;
    unsigned long ipbtotal;
    unsigned long noniptotal;
    unsigned long nonipbtotal;
    unsigned long tcptotal;
    unsigned long tcpbtotal;
    unsigned long udptotal;
    unsigned long udpbtotal;
    unsigned long icmptotal;
    unsigned long icmpbtotal;
    unsigned long othtotal;
    unsigned long othbtotal;
    unsigned long badtotal;

    unsigned long max100;
    unsigned long max200;
    unsigned long max300;
    unsigned long max400;
    unsigned long max500;
    unsigned long max600;
    unsigned long max700;
    unsigned long max800;
    unsigned long max900;
    unsigned long max1000;
    unsigned long max1100;
    unsigned long max1200;
    unsigned long max1300;
    unsigned long max1400;
    unsigned long max1500;
    unsigned long g1500;
};
