/*
 * flash.inc  -  constants for assembler module of FlashCard programmer
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/*
 *====================================================================
 *
 * Definitions used for programming the AMD Flash EPROM chip
 */
#define CMDOFS1		0x2AAA		/* first command address */
#define CMDOFS2		0x5555		/* second command address */
#define CMDOP1		0x55		/* first command opcode */
#define CMDOP2		0xAA		/* second command opcode */

#define AMD_ID		0x2001		/* flash EPROM ID, only support AMD */

#define ERASE1_CMD	0x80		/* first command for erasing full chip */
#define ERASE2_CMD	0x10		/* second command for erasing full chip */
#define READID_CMD	0x90		/* command to read chip ID */
#define PROG_CMD	0xA0		/* command to program a byte */
#define RESET_CMD	0xF0		/* command to reset chip state machine */

#define SEGLOW		0xC800		/* lower range for EPROM segment */
#define SEGHIGH		0xE800		/* upper range for EPROM segment */
#define SEGSTEP		0x0200		/* 8kB steps for EPROM segment */



/*
 *====================================================================
 *
 * Vendor information for the boot rom image. These values have to be
 * identical to those in makeflash.h.
 */

#define VENDOR_MAGIC	"GK-makerom"	/* vendor ID */
#define VENDOR_SIZE	3		/* size of vendor ID in dwords */

#define VENDOR_PROGRAM	16		/* tag for programmer segment */
#define VENDOR_ROMIMAGE	17		/* tag for boot rom image */



/*
 *====================================================================
 *
 * Layout and magic ID of boot rom image header. These values have to
 * be identical to those used by the boot rom. See SPEC.DOC of the
 * boot rom source for further information.
 */

#define	BOOT_MAGIC	0x1B031336	/* boot image header magic cookie */
#define BOOT_SIZE	512		/* total size of boot image header */

#define BOOT_HD_SIZE	4		/* size of header in dwords */
#define BOOT_HD_MAGIC	0		/* offset for header magic number */
#define BOOT_HD_LENGTH	4		/* offset for header length */
#define BOOT_HD_FLAG1	5		/* offset for header flag 1 */
#define BOOT_HD_FLAG2	6		/* offset for header flag 2 */
#define BOOT_HD_FLAG3	7		/* offset for header flag 3 */
#define BOOT_HD_LOCN	8		/* offset for header location */
#define BOOT_HD_EXEC	12		/* offset for execute address */
#define BOOT_HD_VENDOR	16		/* offset for header vendor information */

#define BOOT_LD_SIZE	4		/* size of load record in dwords */
#define BOOT_LD_LENGTH	0		/* offset for load record length */
#define BOOT_LD_TAG1	1		/* offset for load record tag 1 */
#define BOOT_LD_TAG2	2		/* offset for load record tag 2 */
#define BOOT_LD_FLAGS	3		/* offset for load record flags */
#define BOOT_LD_ADDR	4		/* offset for absolute address */
#define BOOT_LD_ILENGTH	8		/* offset for image length */
#define BOOT_LD_MLENGTH	12		/* offset for memory length */
#define BOOT_LD_VENDOR	16		/* offset for vendor information */

#define BOOT_FLAG_B0	0x01		/* mask for load record flag B0 */
#define BOOT_FLAG_B1	0x02		/* mask for load record flag B1 */
#define BOOT_FLAG_EOF	0x04		/* mask for load record flag EOF */

