/*  NETWATCH is based on some code from Statnet */
/* Statnet is protected under the GNU Public License (GPL2). */
/* Author: Jeroen Baekelandt (jeroenb@igwe.vub.ac.be)       */
/* 27DEC95: Scot E. Wilcoxon (sewilco@fieldday.mn.org)     */
/* 
   NETWATCH is VERY loosely based on the code from Statnet...
   thanks out to Jeroen and Scot...

   NETWATCH allows a user (superuser) to monitor an ETHERNET
   and examine activity on the network. Hostnames are highlighted
   in colours (for those supporting them) to indicate activity
   on the bus network based on time ( less than 1 minute RED,
   less than 5 minutes YELLOW, less than 30 minutes GREEN and
   otherwise BLUE). The monitor includes statistics on 
   a) Transmitted and received packets
   b) Protocol of LAST packet (TX or RC)
   c) LAST Communication partner (IP address)

   The number of hosts capable of support is a function of
   memory. They are stored in 2 doubly-linked lists (local
   and remote).

   Screen updates take place 1 per second (unless a rare 
   lockout... when linked list links are updating... in which
   case it displays in the next second)

   Keyboard usage is admittedly limited (and a kludge... due to
   some ncurses settings that need better tinkering)
   ->   Go forward to next option
   <-   Go backward to previous option
   <UP>         Go back to previous page (back 20 lines on most consoles)
   <DOWN>       Go forward to next page (forward 20 lines on most consoles)
   c    Clear counters for fresh counting
   n    Clear linked lists for new start

   It is a simple program to execute for ETHERNET under LINUX.
   It assumes that there is a "/etc/rc.d/rc.inet1" file for
   network configuration. If so, it checks for an "eth0" ifconfig
   and picks up the netmask from the file.

   For those with multiple "eth" interfaces, I am sorry it doesn't
   support both simultaneously.

   AUTHOR:      G. MacKay
   E-MAIL:      mackay@gmml.slctech.org

   P.S.
   Given the fact that I was sick for 3 days and decided to
   write this code... forgive me for not writing beautiful
   code... (those that know me, probably don't think my
   code is beautiful when I am healthy)

   NEW CODE IS COPYRIGHTED to  G. MacKay   under  GPL
 */

/* This is the main program */
#define MAIN_LINE 1

#ifdef OLDLINUX
#include <ncurses.h>
#else
#include <curses.h>
#endif
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <linux/if_ether.h>
#include <strings.h>
#include <sys/ioctl.h>
#include <linux/if.h>
#include <signal.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <linux/icmp.h>
#include <netinet/protocols.h>
#include <netdb.h>
#include <errno.h>
#include <fcntl.h>
#include "curs.h"
#include "netwatch.h"
#include "netresolv.h"

extern int errno;

char *version = "0.7a";
char progtitle[60];

#ifdef _LINUX_IF_ETHER_H
#undef NET_3			/* not using Net/3 definitions */
#endif

#ifndef ETH_HLEN
#define ETH_HLEN 14		/* Ethernet header length */
#endif

#ifndef ETH_P_ATALK
#define ETH_P_ATALK 0x809B	/* Appletalk */
#endif

#ifndef SOCK_PACKET
#define SOCK_PACKET SOCK_RAW	/* If SOCK_PACKET is wrong, try SOCK_RAW */
#endif

#ifndef NET_3
#define ether_head	ethhdr	/* ether_head structure */
#define ether_type	h_proto	/* Ethernet Packet Type ID field */
#define ip		iphdr	/* IP header structure */
#define ip_off		frag_off	/* IP protocol field */
#define ip_p		protocol	/* IP protocol field */
#define ip_hl		ihl	/* IP header length field */
#define th_sport	source	/* TCP source port field */
#define th_dport	dest	/* TCP destination port field */
#define ui_sport	source	/* UDP source port field */
#define ui_dport	dest	/* UDP destination port field */
#endif

#define SN_RCV_BUF_SIZE	(sizeof(struct ether_head)+ \
				 sizeof(struct ip)+ \
                                 sizeof(struct options)+ \
				 sizeof(struct tcphdr)+4)
#define SN_RCV_BIGBUFSIZE SN_RCV_BUF_SIZE+80
/* above was 1600, but kernel discards */
/* excess and tells us full length,   */
/* so we only need enough to analyze. */
int sn_rcv_bufsize = SN_RCV_BUF_SIZE;
int ESCON = 0;
#define ESC 0x1b
#define RETURNKEY 0x0d
#define CONTROLL  12
#define MAXHELPPAGE 3
HOSTINFO ldummy, rdummy;
HOSTINFO *lfirst, *rfirst, *previous, *current, *next, *work;
struct itimerval newtm, oldtm;	/* TIMER for measuring */
time_t new;
time_t starttime;
char configfile[128] = "/etc/rc.d/rc.inet1";
char statsfile[128] = "/etc/netwatch.stats";
int newconfig = FALSE;
char ethdevname[64] = "eth0";
int newethname = FALSE;
int probcnt = 0;		/*  Problem Count  on ETH reads */
int intrcnt = 0;		/*  EINTR hits  on ETH reads */

#define MAGNABUFSIZE 4196
struct magrec
  {
    int len;
    char dir;
    unsigned char buf[MAGNABUFSIZE];
  };
#define MAGNAMAX 10
#define MAGNAOFFS 40
struct magrec magna[MAGNAMAX];
int magnacnt = 0;
int magnaoffs = MAGNAOFFS;
char magnamatch[80];
HOSTINFO *magnaspot;
unsigned long int magnakey;
int magnaphys = 0;
int magnafirst = TRUE;
int magnafull = FALSE;
HOSTINFO *magnacomhost = NULL;
unsigned long int magnacomkey;

double maxburst = 0.0;
unsigned char netmask[4] =
{255, 255, 255, 0};
unsigned char localaddr[4];
int ethok = 1;
struct hostent *hostent;
int wai = 0;
int selprob = 0;
int selcode = 0;
int bugfix = FALSE;
int help = FALSE;
int helppage = 1;
int watch = FALSE;
int remoterow = -1;
int localrow = -1;
int localupdate = 0;
int remoteupdate = 0;
int poschange = 0;
int refreshloc = 0;
int refreshrem = 0;
int refreshgen = 0;
int llockout = 0;
int rlockout = 0;
int lydisp = 0;
int rydisp = 0;
int ydisp = 0;
int localkey = TRUE;
int dispopt = DISP_TX_RC;
int colour;
unsigned long int routeruse = 0;
unsigned long int routerto = 0;
unsigned long int routerfrom = 0;
int disprouterstats = FALSE;
int scrmid;
int selecthost = FALSE;
int numselect = 0;
int selectside = 0;
int selectchange = FALSE;
int bluedie = 0;
int ignoredomain = 0;
int statpid = -1010;		/* Magic number to indicate NO status process present */

int sd;
/*  For screen size independent settings.... display... */
int curskeyspot;
int curskeyval;
int cursllockout;
int cursrlockout;
int curslines;
int curshosttrim;
int cursproto;
int cursdest;

long int ethcnt = 0;
int keycnt = 0;

#define SMALLSCREEN 0
#define FULLSCREEN 1


struct ifreq ifr, oldifr;

struct at_frame_type
  {
    unsigned char filler[20];
    __u16 appletalk_type1;	/* what is formal name? */
    unsigned char filler2[12];
    __u8 appletalk_type2;	/* what is formal name? */
  };				/* Ethernet Appletalk */

void handle_frame (unsigned char *buf, int length, struct sockaddr *saddr);
void handle_ip (struct ip *buf, int length);
void processinetrc (unsigned char *netmask, unsigned char *local, int *peth);



typedef void (*sigfunc) (int);

    static pid_t mypid, child;
	int msocket[2];
	int osocket[2];
	int resolvetimeout=0;

void handletimeout(int sig)
{
	resolvetimeout = 10;
/*	printf("Got TIMEOUT\n");  */
	signal(SIGUSR1,handletimeout);
}

void handlechild(int sig)
{
	int status; 
	pid_t killpid;

	killpid = wait(&status);
/*	if (WIFSIGNALED(status))
	{
		printf("Abnormal termination... signal #%d for %ld\n",
			WTERMSIG(status),killpid);
	}
*/
}

void processres(int sig)
{
	struct gotname one;

/*	printf("Got Signal PROCESSRES\n");  */
	read(osocket[0],&one,sizeof(one));
	signal(SIGUSR2,processres);
	strcpy(one.where,one.name);	
}

void setupsignals()
{
	signal(SIGUSR1,handletimeout);
	signal(SIGUSR2,processres);


}


void mygethostbyaddr(char *where, unsigned char *p, int len, int proto)
{
	struct resolvaddr one;

	one.pid = mypid;
	one.inetaddr = *(unsigned long *)p;
	one.where = where;
/*	printf("Writing to MSOCKET[1]... PID=%lu  WHERE=%p INETADDR=%lu\n",
		mypid,where,one.inetaddr);   */
	write(msocket[1],&one,sizeof(one));
/*	sleep(1);   */
	kill(child,SIGUSR1);
/*	sleep(1);   */
}




void
clearentry (HOSTINFO * current)
{
  current->pktcntsend = current->pktcntrec = 0;
  current->intpktcntsend = current->intpktcntrec = 0;
  current->extpktcntsend = current->extpktcntrec = 0;
  current->sendbytes = current->recbytes = 0;
  current->intsendbytes = current->intrecbytes = 0;
  current->extsendbytes = current->extrecbytes = 0;


}

/*
   FOR RELIABLE SIGNAL HANDLING --- make sure a restart of
   system calls is performed when signals interrupt
 */
sigfunc
signal (int signo, sigfunc func)
{
  struct sigaction act, oact;

  act.sa_handler = func;
  sigemptyset (&act.sa_mask);
  act.sa_flags = 0;
  if (signo != SIGALRM)
    act.sa_flags |= SA_RESTART;
  if (sigaction (signo, &act, &oact) < 0)
    return (SIG_ERR);
  return (oact.sa_handler);
}

/*
   FOR SELECT System call SIGNAL HANDLING --- make sure there is NO 
   restart of system calls when signals interrupt
 */
sigfunc
signal_intr (int signo, sigfunc func)
{
  struct sigaction act, oact;

  act.sa_handler = func;
  sigemptyset (&act.sa_mask);
  act.sa_flags = 0;
  if (sigaction (signo, &act, &oact) < 0)
    return (SIG_ERR);
  return (oact.sa_handler);
}

/*
   Simple Control C and Hangup handler... to clean the
   screen
 */
void
intrhandle ()
{
  kill(child,SIGHUP);
  cleanup_curses ();

/* Should this be rewritten to cooperate with other net tools? */
  strcpy (oldifr.ifr_name, ethdevname);
  if (ioctl (sd, SIOCSIFFLAGS, &oldifr) < 0)
    {
      perror ("Can't set flags: ");
      close (sd);
      gh (3);
      exit (4);
    }

  close (sd);
  gh (1);
  exit (0);

}

void indepscreen ();

void
winchange ()
{
  indepscreen ();
}


/*
   A Routine to Log the CURRENT (passed) Record to the
   log file which is already open for use
 */
void 
logcurr (HOSTINFO * c, FILE * fp)
{
/*
   struct hostinfo {
   unsigned char addr[4];
   unsigned char othaddr[4];
   char name[40];
   char ip_pr[10];
   char servicename[40];
   unsigned long pktcntsend;
   unsigned long extpktcntsend;
   unsigned long intpktcntsend;
   unsigned long pktcntrec;
   unsigned long extpktcntrec;
   unsigned long intpktcntrec;
   time_t       tstamp;
   unsigned long sendbytes;
   unsigned long extsendbytes;
   unsigned long intsendbytes; 
   unsigned long recbytes;
   unsigned long extrecbytes;
   unsigned long intrecbytes; 
   int disprow;
   char update;
   char *inpacklog;
   char *outpacklog;
   struct hostinfo *flink;
   struct hostinfo *blink;
   };

 */
  static char tmphost[80];
  hostent = gethostbyaddr ((char *) c->othaddr, 4, AF_INET);
  if (hostent)
    strcpy (tmphost, hostent->h_name);
  else
    strcpy (tmphost, "<unresolved>");

  fprintf (fp, "HOST=%s     LAST ACCESS=%s", c->name, ctime (&(c->tstamp)));
  fprintf (fp, "IP Addr = %u.%u.%u.%u\n", c->addr[0], c->addr[1],
	   c->addr[2], c->addr[3]);
  fprintf (fp, "Last Communication to %u.%u.%u.%u known as %s\n", c->othaddr[0], c->othaddr[1],
	   c->othaddr[2], c->othaddr[3], tmphost);
  fprintf (fp, "with Protocol %s and Service %s\n", c->ip_pr, c->servicename);
  fprintf (fp, "Packet Counts    Incoming      Outgoing\n");
  fprintf (fp, "    ALL          %8lu      %8lu\n", c->pktcntrec, c->pktcntsend);
  fprintf (fp, "   LOCAL         %8lu      %8lu\n", c->intpktcntrec, c->intpktcntsend);
  fprintf (fp, "  REMOTE         %8lu      %8lu\n", c->extpktcntrec, c->extpktcntsend);
  fprintf (fp, "\n BYTE Counts    Incoming      Outgoing\n");
  fprintf (fp, "    ALL          %8lu      %8lu\n", c->recbytes, c->sendbytes);
  fprintf (fp, "   LOCAL         %8lu      %8lu\n", c->intrecbytes, c->intsendbytes);
  fprintf (fp, "  REMOTE         %8lu      %8lu\n", c->extrecbytes, c->extsendbytes);
  fprintf (fp, "\n\n");

}

/*      Handle dumping stats to a file for use at a later time... */

void 
gostats ()
{
  HOSTINFO *current;
  FILE *fp;
  time_t here;

  here = time (0);
  fp = fopen (statsfile, "a");
  if (fp == NULL)
    return;
  fprintf (fp, "\nStatistics    from %s to %s\n",
	   ctime (&starttime), ctime (&here));
  fprintf (fp, "\nLOCAL STATISTICS\n");
  current = lfirst->flink;
  while (current != lfirst)
    {
      logcurr (current, fp);
      current = current->flink;
    }
  fprintf (fp, "\nREMOTE STATISTICS\n");
  current = rfirst->flink;
  while (current != rfirst)
    {
      logcurr (current, fp);
      current = current->flink;
    }
  fclose (fp);
}

void
disphelp (int helppage, int xoff)
{
  switch (helppage)
    {
    case 1:
      mvprintw (6, xoff + 10, "HELP WINDOW");
      mvprintw (8, xoff + 3, "Normal Mode Commands");
      mvprintw (10, xoff + 3, "<TAB>  - toggle REMOTE/LOCAL");
      mvprintw (11, xoff + 3, "         for keyboard control");
      mvprintw (12, xoff + 3, "<LEFT> - Go back ONE Option");
      mvprintw (13, xoff + 3, "<RIGHT>  Go forward ONE OPTION");
      mvprintw (14, xoff + 3, "<UP>   - Back ONE PAGE on");
      mvprintw (15, xoff + 3, "         CURRENT (REMOTE/LOCAL)");
      mvprintw (16, xoff + 3, "<DOWN> - Forward ONE PAGE on");
      mvprintw (17, xoff + 3, "         CURRENT (REMOTE/LOCAL)");
      mvprintw (18, xoff + 3, "<ESC>  Exit HELP MODE");
      mvprintw (19, xoff + 3, "or <F10>");
      mvprintw (20, xoff + 3, "or <END>    <ENTER> for MORE Help");
      break;
    case 2:
      mvprintw (6, xoff + 10, "HELP WINDOW");
      mvprintw (8, xoff + 3, "Special Mode Commands");
      mvprintw (10, xoff + 3, "c      - Clear Counters (Packets");
      mvprintw (11, xoff + 3, "         and Bytes) ");
      mvprintw (12, xoff + 3, "n      - NEW Host List (Restart)");
      mvprintw (13, xoff + 3, "w      - Enter WATCH Mode");
      mvprintw (14, xoff + 3, "         (Special Commands on");
      mvprintw (15, xoff + 3, "          WATCH mode on WATCH");
      mvprintw (16, xoff + 3, "          PAGE)");
      mvprintw (18, xoff + 3, "<ESC>  Exit HELP MODE");
      mvprintw (19, xoff + 3, "or <F10>");
      mvprintw (20, xoff + 3, "or <END>    <ENTER> for MORE Help");
      break;
    case 3:
      mvprintw (6, xoff + 10, "HELP WINDOW");
      mvprintw (8, xoff + 3, "Additional Commands");
      mvprintw (10, xoff + 3, "l      - Log stats to log file");
      mvprintw (11, xoff + 3, "b      - Toggle Blue Hosts ");
      mvprintw (12, xoff + 3, "          displayed or not");
      mvprintw (13, xoff + 3, "d      - Toggle DOMAIN Hosts");
      mvprintw (14, xoff + 3, "          service displayed");
      mvprintw (15, xoff + 3, "          or not");
      mvprintw (16, xoff + 3, "          ");
      mvprintw (18, xoff + 3, "<ESC>  Exit HELP MODE");
      mvprintw (19, xoff + 3, "or <F10>");
      mvprintw (20, xoff + 3, "or <END>    <ENTER> for MORE Help");
      break;

    }
}

void
setupauxscr (int *xoff, int bigscreen)
{
  int xst = 1;
  int xend;

  xend = scrmid;
  if (localkey)
    {
      xst = scrmid + 1;
      xend = COLS - 1;
    }
  if (bigscreen)
    {
      xst = 1;
      xend = COLS - 1;
    }
  clrportion (4, xst, LINES - 1, xend);
  mvhline (4, xst + 1, ACS_BLOCK, xend - xst - 2);
  mvhline (LINES - 3, xst + 1, ACS_BLOCK, xend - xst - 2);
  mvvline (5, xst + 1, ACS_BLOCK, LINES - 8);
  mvvline (5, xend - 2, ACS_BLOCK, LINES - 8);
  *xoff = xst;
}

void
setuphelp ()
{
  int xoff = 1;
  setupauxscr (&xoff, SMALLSCREEN);
  disphelp (helppage, xoff);
}

void
setupwatch (int bigscreen)
{
  int xoff = 1;

  setupauxscr (&xoff, bigscreen);
  if (!bigscreen)
    {
      mvprintw (6, xoff + 10, "WATCH WINDOW");
      if (!disprouterstats)
	{
	  mvprintw (8, xoff + 3, "Special Commands");
	  mvprintw (10, xoff + 3, "s   - select host for trace");
	  mvprintw (11, xoff + 3, "       Up/Down   Left/Right");
	  mvprintw (12, xoff + 3, "      <new host> <pkt. spot>");
	  mvprintw (13, xoff + 3, "r   - examine router stats");
	  mvprintw (14, xoff + 3, "<ESC>  Exit WATCH MODE");
	  mvprintw (15, xoff + 3, "or <F10>");
	  mvprintw (16, xoff + 3, "or <END>");
	}
    }
}

void 
indepscreen ()
{
  curskeyspot = COLS - 12;
  curskeyval = COLS - 5;
  cursllockout = COLS - 18;
  cursrlockout = COLS - 15;
  curslines = COLS - 10;
  curshosttrim = COLS / 2 - 17;
  cursproto = curshosttrim - 7;
  cursdest = curshosttrim - 2;

}

/*      Use SELECT system call to read in characters and process
   OR read in the Ethernet Buffer...
 */
int 
process ()
{
  static char dumbuf[80];
  char dum;
  int n;
  long int cmset, rset, cset, eset;
  int maxfd;
  int tfd = 0;
  static int fair = 0;
  struct timeval seltime;
  	
  
  rset = 1 << sd;
  rset |= 1;			/* FAST METHOD of Setting FD 0 and FD SD bits */
  /*
     FD_SET(sd, &rset);
     FD_SET(tfd, &rset);
   */
  cset = eset = rset;
  maxfd = sd + 1;
  while (TRUE)
    {
      rset = cset;
      selprob = 1;
      seltime.tv_sec =  1;
      seltime.tv_usec = 0;
      if ((selcode = select (maxfd, (fd_set *) & rset, NULL, (fd_set *) & eset
           , &seltime)) <= 0)
	{
	  if (errno == EINTR)
	    continue;
	  perror ("SELECT");
	  return (1);
	}
      if (!eset && !rset)
	{
	  /* Not possible... */
	  continue;
	}
      if (eset)
	{
	  selprob = 55;
	  if (FD_ISSET (tfd, (fd_set *) & eset))
	    {
	      read (tfd, &dum, 1);
	      keycnt++;
	    }
	  if (FD_ISSET (sd, (fd_set *) & eset))
	    {
	      n = read (sd, dumbuf, 80);
	      ethcnt++;
	    }
	} 
      selprob = 0;
      if (FD_ISSET (tfd, (fd_set *) & rset))
	{
	  selprob = 3;
	  if (dokeyin () < 0)
	    return (0);
	    
	  keycnt++;
	}
      if (FD_ISSET (sd, (fd_set *) & rset))
	{
	  selprob = 4;
	  if (doeth () < 0)
	    return (2);
	  ethcnt++; 
	}
    } 
}



main (int argc, char *argv[])
{
  int dum;
  char *device = ETH;

  {				/* Compound statement to make initializers vanish after init. */
    int op;

    starttime = time (0);
    gh (0);
    for (op = 0; op < MAGNAMAX; op++)
      magna[op].len = -1;
    strcpy (progtitle, "NETWATCH Program Version ");
    strcat (progtitle, version);
	pipe(msocket);
	pipe(osocket);
	mypid = getpid();	
	setupsignals();
	if ( (child = fork())==0)   /* CHILD */
	{
		close(0);
		signal(SIGUSR1,SIG_DFL);
		signal(SIGUSR2,SIG_DFL);
		signal(SIGALRM,SIG_DFL);
		dup2(msocket[0],0);
		close(msocket[0]);
		close(1);
		dup2(osocket[1],1);
		close(osocket[1]);
	 	execlp("netresolv","netresolv",NULL);
		perror("NETRESOLV");
		exit(1);
	}
	close(msocket[0]);
	close(osocket[1]);
	signal(SIGCHLD,handlechild);
    
    rewrite_labels = 1;
    lfirst = &ldummy;		/* The dummy record header for linked list */
    lfirst->flink = lfirst;
    lfirst->blink = lfirst;
    lfirst->disprow = localrow;

    rfirst = &rdummy;		/* The dummy record header for linked list */
    rfirst->flink = rfirst;
    rfirst->blink = rfirst;
    rfirst->disprow = remoterow;
/* Initialize here the labels for the services listed above. */
    services ();		/* default labels for these services */
/* TCP names */
    strcpy (tcp_port_types[20], "FTP:");
    strcpy (tcp_port_types[23], "Telnet:");
    strcpy (tcp_port_types[25], "SMTP:");
    strcpy (tcp_port_types[42], "DNS:");
    strcpy (tcp_port_types[79], "Finger:");
    strcpy (tcp_port_types[80], "WWW:");
    strcpy (tcp_port_types[101], "NIC Host NS:");
    strcpy (tcp_port_types[103], "X400:");
    strcpy (tcp_port_types[109], "POP2:");
    strcpy (tcp_port_types[111], "RPC/NFS:");
    strcpy (tcp_port_types[119], "NNTP:");
    strcpy (tcp_port_types[137], "NetB NS:");	/* NetBIOS Name Service */
    strcpy (tcp_port_types[138], "NetB Dg:");	/* NetBIOS Datagram */
    strcpy (tcp_port_types[139], "NetBIOS:");	/* NetBIOS Session Service */
    strcpy (tcp_port_types[194], "IRC:");	/* Internet Relay Chat */
    strcpy (tcp_port_types[515], "Printer:");	/* lpd print protocol */
    strcpy (tcp_port_types[520], "RIP:");

/* now UDP */
    strcpy (udp_port_types[20], "FTP:");
    strcpy (udp_port_types[23], "Telnet:");
    strcpy (udp_port_types[25], "SMTP:");
    strcpy (udp_port_types[42], "DNS:");
    strcpy (udp_port_types[79], "Finger:");
    strcpy (udp_port_types[80], "WWW:");
    strcpy (udp_port_types[101], "NIC Host NS:");
    strcpy (udp_port_types[103], "X400:");
    strcpy (udp_port_types[109], "POP2:");
    strcpy (udp_port_types[111], "RPC/NFS:");
    strcpy (udp_port_types[119], "NNTP:");
    strcpy (udp_port_types[137], "NetB NS:");	/* NetBIOS Name Service */
    strcpy (udp_port_types[138], "NetB Dg:");	/* NetBIOS Datagram */
    strcpy (udp_port_types[139], "NetBIOS:");	/* NetBIOS Session Service */
    strcpy (udp_port_types[194], "IRC:");	/* Internet Relay Chat */
    strcpy (udp_port_types[515], "Printer:");	/* lpd print protocol */
    strcpy (udp_port_types[520], "RIP:");

    help_flag = 0;		/* No help unless asked for */
    redraw_screen = 0;		/* No redraw unless asked for */
    while ((op = getopt (argc, argv, "hc:e:")) != EOF)
      {
	switch (op)
	  {
	  case 'c':
	    strncpy (configfile, optarg, 256);
	    newconfig = TRUE;
	    break;
	  case 'e':
	    strncpy (ethdevname, optarg, 64);
	    newethname = TRUE;
	    break;
	  case ':':
	    fprintf (stderr, "Missing Parameter\n\n");
	  case 'h':
	  default:
	    usage (argv[0]);
	    break;
	  }
      }
    processinetrc (netmask, localaddr, &ethok);
    if (!ethok)
      {
	printf ("NO %s Interface to work on!!\n", ethdevname);
	gh (3);
	exit (1);
      }

/*      printf("NETMASK=%u.%u.%u.%u    LOCALADDR=%u.%u.%u.%u\n",
   netmask[0],netmask[1],netmask[2],netmask[3],
   localaddr[0],localaddr[1],localaddr[2],localaddr[3]);
   getchar(); */
/* INIT ALARMFUCTION: Alarm triggers update of the display */

    if (signal_intr (SIGINT, intrhandle) == SIG_ERR)
      {
	perror ("INT Signal error: ");
	gh (3);
	exit (5);
      }

    if (signal_intr (SIGHUP, intrhandle) == SIG_ERR)
      {
	perror ("HUP Signal error: ");
	gh (3);
	exit (5);
      }

    if (signal_intr (SIGALRM, dispdata) == SIG_ERR)
      {
	perror ("ALRM Signal error: ");
	gh (3);
	exit (5);
      }

    if (signal_intr (SIGWINCH, winchange) == SIG_ERR)
      {
	perror ("ALRM Signal error: ");
	gh (3);
	exit (5);
      }

/* OPEN SOCKET */

    if ((sd = socket (AF_INET, SOCK_PACKET, htons (ETH_P_ALL))) < 0)
      {
	perror ("Can't get socket: ");
	gh (3);
	exit (1);
      }

/* SET PROMISC */

    strcpy (oldifr.ifr_name, ethdevname);
    if (ioctl (sd, SIOCGIFFLAGS, &oldifr) < 0)
      {
	perror ("Can't get flags: ");
	close (sd);
	gh (3);
	exit (2);
      }

/* Should this be rewritten to cooperate with other net tools? */
    ifr = oldifr;
    ifr.ifr_flags |= IFF_PROMISC;
    strcpy (ifr.ifr_name, ethdevname);
    if (ioctl (sd, SIOCSIFFLAGS, &ifr) < 0)
      {
	perror ("Can't set flags: ");
	close (sd);
	gh (3);
	exit (3);
      }
    fcntl (sd, F_SETFL, FNDELAY); 	/* No delay... although waiting at SELECT! */
  }				/* Compound statement to make initializer variables vanish after init. */
/* END OF INITIALISATION */
  /*  init_curses (); *//* initialize the screen */
  initscr ();
  cbreak ();
  noecho ();
  nodelay (stdscr, TRUE);
  nonl ();
  keypad (stdscr, TRUE);
  intrflush (stdscr, FALSE);
  indepscreen ();
/*  if (has_colors ()) */
  {
    colour = TRUE;
    start_color ();
    init_pair (4, COLOR_WHITE, COLOR_BLUE);
    init_pair (1, COLOR_WHITE, COLOR_RED);
    init_pair (2, COLOR_BLACK, COLOR_YELLOW);
    init_pair (3, COLOR_BLACK, COLOR_GREEN);
    col1 = COLOR_PAIR (1);
    col2 = COLOR_PAIR (2);
    col3 = COLOR_PAIR (3);
    col4 = COLOR_PAIR (4);
  }
/*  else
   {
   colour = FALSE;
   col1 = A_BLINK;
   col2 = A_REVERSE;
   col3 = A_BOLD;
   col4 = A_NORMAL;

   } */
  clrscr ();			/* clear the screen */
  alarm (1);			/* first screen update in about a second */
  /* newtm.it_value.tv_sec = 1;
     newtm.it_value.tv_usec = 0;
     setitimer (ITIMER_REAL, &newtm, &oldtm); *//* first screen update in 1 sec (exact) */
  process ();

/* TERMINATE */

/*
 */
  kill(child,SIGHUP);
  cleanup_curses ();

/* Should this be rewritten to cooperate with other net tools? */
  strcpy (oldifr.ifr_name, ethdevname);
  if (ioctl (sd, SIOCSIFFLAGS, &oldifr) < 0)
    {
      perror ("Can't set flags: ");
      close (sd);
      gh (3);
      exit (4);
    }

  close (sd);
  gh (1);
  exit (0);
}


void
handle_other (unsigned char *buf, int length)
{

/* frame_protocol is global */
  if (frame_protocol < 1501)
    {				/* if IEEE 802.3 packet instead of Ethernet packet (per RFC 1700) */
      if ((short int) buf[14] <= SN_MAX_SAP)
	{
	  sap_count[(short int) buf[14]]++;	/* count 802.2 SAP number */
	}
      regis.new_ethernet_count++;
    }				/* if IEEE 802.3 packet instead of Ethernet packet */
  else
    {				/* else is an Ethernet packet */
      switch (((struct at_frame_type *) buf)->appletalk_type1)	/* Appletalk */
	{
	case __constant_ntohs (ETH_P_ATALK):
/*        if (regis.at_option)
   exatalk ((struct at_frame_type *) buf, length); */
	  break;
	case __constant_ntohs (0x80F3):
	  regis.aarp++;
	  break;
	default:
	  break;
	}
    }				/* else is an Ethernet packet */
}

void
makeaddr (unsigned char naddr[], char ascii[])
{
  sprintf (ascii, "%u.%u.%u.%u        ", naddr[0], naddr[1], naddr[2], naddr[3]);
  ascii[15] = 0;
  return;
}

int
tlocal (unsigned long *addr)
{
  static unsigned char lhost[] =
  {127, 0, 0, 1};
  unsigned long *k = (unsigned long *) netmask;
  unsigned long reslocal, restest;
  if (*addr == *(unsigned long *) lhost)
    return (TRUE);
  restest = *addr & *k;
  reslocal = *(unsigned long *) localaddr & *k;
  return (restest == reslocal);
}

void
searchforinsertion (unsigned long key, HOSTINFO * first)
{
  current = first->flink;
  while (current != first && key < (unsigned long) ntohl (*(unsigned long *) current->addr))
    current = current->flink;
}

#define LOCUPDATE	1
#define REMUPDATE	0

void
updatecurrent (HOSTINFO * work, struct ip *buf, int length, int opt, int destlocal, int orglocal)
{
  int x;
  unsigned long wlen;

  wlen = (unsigned long) ntohs (buf->tot_len);
/* Update current entries */
  if (opt)			/* DEST */
    {
      work->pktcntrec++;
      if (orglocal)
	{
	  if (destlocal)
	    {
	      work->intrecbytes += wlen;
	      work->intpktcntrec++;
	    }
	  else
	    {
	      work->extrecbytes += wlen;
	      work->extpktcntrec++;
	    }
	}
      work->recbytes += wlen;
    }
  else
    {
      work->pktcntsend++;
      if (orglocal)
	{
	  if (destlocal)
	    {
	      work->intsendbytes += wlen;
	      work->intpktcntsend++;
	    }
	  else
	    {
	      work->extsendbytes += wlen;
	      work->extpktcntsend++;
	    }
	}
      work->sendbytes += wlen;
    }
    refresh();
    
  work->tstamp = new;
  x = buf->ip_p;
  if (x <= 100 && x >= 0)
    strcpy (work->ip_pr, ip_protocol_types[x]);
  else if (x > 0 && x < 256)
    sprintf (work->ip_pr, "UNK %d", x);
  else
    sprintf (work->ip_pr, "ILL %d", x);
  if (!opt)
    {
      switch (buf->ip_p)
	{
	case IPPROTO_TCP:
	  if ((x = ntohs (((struct tcphdr *) ((void *) buf + 20))->th_sport)) <= SN_MAX_TCP_PORTS)
	    strcpy (work->servicename, tcp_port_types[x]);
	  else
	    sprintf (work->servicename, "UNK %d", x);
	  break;
	case IPPROTO_UDP:
	  if ((x = ntohs (((struct udphdr *) ((void *) buf + 20))->th_sport)) <= SN_MAX_UDP_PORTS)
	    strcpy (work->servicename, udp_port_types[x]);
	  else
	    sprintf (work->servicename, "UNK %d", x);
	  break;
	case IPPROTO_ICMP:
	  x = *(u_char *) ((void *) buf + 20);
	  if (x == ICMP_ECHO)
	    strcpy (work->servicename, "ECHO");
	  else if (x == ICMP_ECHOREPLY)
	    strcpy (work->servicename, "ECHO REPLY");
	  else
	    sprintf (work->servicename, "OTH %d", x);
	  break;
	default:
	  strcpy (work->servicename, "?????");
	}
    }
refresh();
}


/* opt = 0 SOURCE   opt = 1  DEST. */

void
addtolocallist (unsigned long *key, unsigned long *okey, struct ip *buf, int length, int opt)
{
  static int mcnt = 0;
  static int ncnt = 0;
  unsigned char *pk = (unsigned char *) key;
  unsigned long wlen;

  wlen = (unsigned long) ntohs (buf->tot_len);

  searchforinsertion ((unsigned long) ntohl (*key), lfirst);
  if (*(unsigned long *) current->addr != *key)
    {
      work = (HOSTINFO *) malloc (sizeof (*work));
      previous = current->blink;
/* Init values to ZERO for 1st entry.... */
      clearentry (work);
      *(unsigned long *) work->addr = *key;
      work->disprow = previous->disprow + 1;
      work->update = 1;
      localupdate = 1;
      sprintf (work->name, "%u.%u.%u.%u", pk[0], pk[1], pk[2], pk[3]);
      mygethostbyaddr(work->name,(char *) key, 4, AF_INET);
      llockout = 1;
      previous->flink = work;
      work->flink = current;
      current->blink = work;
      work->blink = previous;
      llockout = 0;
    }
  else
    {
      work = current;
      work->update = 2;		/* just info update */
      localupdate = 1;
    }
  if (*key == magnakey)
    {
	if (*okey!= magnacomkey)
	{
		magnacomhost = NULL;
		magnacomkey = *okey;
	}
      if (wlen > MAGNABUFSIZE)
	wlen = MAGNABUFSIZE;
      magna[magnacnt].len = wlen;
      magna[magnacnt].dir = opt;
      memcpy (magna[magnacnt++].buf, buf, wlen);
      if (!magnafirst)
	{
	  magnaphys++;
	  if (magnaphys == MAGNAMAX)
	    magnaphys = 0;
	}
      if (magnacnt == MAGNAMAX)
	{
	  magnacnt = 0;
	  magnafirst = FALSE;
	}
    }
  if (selecthost && magnacomhost == NULL && *key == magnacomkey)
    {
      magnacomhost = work;
    }
  *(unsigned long *) work->othaddr = *okey;

  if (tlocal (okey))
    updatecurrent (work, buf, length, opt, LOCUPDATE, LOCUPDATE);
  else
    updatecurrent (work, buf, length, opt, REMUPDATE, LOCUPDATE);
}

void
addtoremotelist (unsigned long *key, unsigned long *okey, struct ip *buf, int length, int opt)
{
  unsigned char *pk = (unsigned char *) key;
  int x;
  unsigned long wlen;

  wlen = (unsigned long) ntohs (buf->tot_len);

  searchforinsertion ((unsigned long) ntohl (*key), rfirst);
  if (*(unsigned long *) current->addr != *key)
    {
      work = (HOSTINFO *) malloc (sizeof (*work));
      previous = current->blink;
/* Init values to ZERO for 1st entry.... */
      clearentry (work);
      work->disprow = previous->disprow + 1;
      work->update = 1;
      remoteupdate = 1;
      *(unsigned long *) work->addr = *key;
      sprintf (work->name, "%u.%u.%u.%u", pk[0], pk[1], pk[2], pk[3]);
      mygethostbyaddr(work->name,(char *) key, 4, AF_INET);
      rlockout = 1;
      previous->flink = work;
      work->flink = current;
      current->blink = work;
      work->blink = previous;
      rlockout = 0;
    }
  else
    {
      work = current;
      work->update = 2;		/* just info update */
      remoteupdate = 1;
    }
  if (*key == magnakey)
    {
	if (*okey!= magnacomkey)
	{
		magnacomhost = NULL;
		magnacomkey = *okey;
	}

      if (wlen > MAGNABUFSIZE)
	wlen = MAGNABUFSIZE;
      magna[magnacnt].len = wlen;
      magna[magnacnt].dir = opt;
      memcpy (magna[magnacnt++].buf, buf, wlen);
      if (!magnafirst)
	{
	  magnaphys++;
	  if (magnaphys == MAGNAMAX)
	    magnaphys = 0;
	}
      if (magnacnt == MAGNAMAX)
	{
	  magnacnt = 0;
	  magnafirst = FALSE;
	}
    }
  if (selecthost && magnacomhost == NULL && *key == magnacomkey)
    {
      magnacomhost = work;
    }

  *(unsigned long *) work->othaddr = *okey;
  if (tlocal (okey))
    updatecurrent (work, buf, length, opt, LOCUPDATE, REMUPDATE);
  else
    updatecurrent (work, buf, length, opt, REMUPDATE, REMUPDATE);

}

void
handle_ip (struct ip *buf, int length)
{
  static int x;
  long sourcel;
  long destl;
  struct hostent *hostent;
  unsigned long wlen;


  new = time (0);
  wlen = (unsigned long) ntohs (buf->tot_len);
  selprob = 40;
  if (buf->ip_p <= SN_MAX_IP_PORT)
    {				/* if IP protocol type is to be tallied */
      ip_protocol_count[buf->ip_p]++;
    }				/* if IP protocol type is to be tallied */
  if (tlocal ((long int *) &buf->saddr))
    addtolocallist ((unsigned long int *) &buf->saddr, (unsigned long int *) &buf->daddr, buf, length, 0);
  else
    {
      addtoremotelist ((unsigned long int *) &buf->saddr, (unsigned long int *) &buf->daddr, buf, length, 0);
      routeruse += wlen;
      routerfrom += wlen;
    }
  if (tlocal ((long int *) &buf->daddr))
    addtolocallist ((unsigned long int *) &buf->daddr, (unsigned long int *) &buf->saddr, buf, length, 1);
  else
    {
      addtoremotelist ((unsigned long int *) &buf->daddr, (unsigned long int *) &buf->saddr, buf, length, 1);
      routeruse += wlen;
      routerto += wlen;
    }
  selprob = 41;
}

void
handle_frame (unsigned char *buf, int length, struct sockaddr *saddr)
{
  int prot_int;
  int search_int;
  int prot_now;
  struct ip *ip_ptr;

  selprob = 30;
  ip_ptr = (struct ip *) ((void *) buf + ETH_HLEN);

  if (length > 0)
    {
      packet_type = ((struct ether_head *) buf)->ether_type;	/* Ethernet packet type ID field */
      frame_protocol = ntohs (packet_type);	/* Convert from network to host seq */
      if (frame_protocol < 1501)
	{			/* if an IEEE 802.3 packet */
	  frame_protocol = SN_PROT_IEEE802_3;
	}			/* if an IEEE 802.3 packet */

      switch (frame_protocol)
	{
	case ETH_P_IP:
	case SN_PROT_PPP:
	case SN_PROT_SLIP:
	case SN_PROT_LOOP:
	  selprob = 31;
	  handle_ip (ip_ptr, length);
	  break;
	default:
	  selprob = 32;
	  handle_other (buf, length);
	  break;
	}

    }				/* if length > 0 */
  selprob = 35;
}

void
usage (char *arg)
{
  fprintf (stderr, "\n%s [-h][-c rcinetfile][-e ethdevice]\n\n", arg);
  fprintf (stderr, "Network Watch (Ethernet/IP)\nVersion %s\n\n", version);
  fprintf (stderr, "\t-c rcinetfile\tAlternate to System rc.inet1 file\n");
  fprintf (stderr, "\t-e ethnum\tAlternate to eth0 ( -e eth1  for eth1 )\n");
  fprintf (stderr, "\t-h\t\tHelp Message (this)\n\n");
  gh (2);
  exit (0);
}

int 
doeth ()
{
  static struct sockaddr saddr;
  int sizeaddr;
  static unsigned char buf[SN_RCV_BUF_SIZE + 400];
  int length;
  int cont=FALSE;

  do
    {
      sizeaddr = sizeof (struct sockaddr);
      length = recvfrom (sd, buf, sn_rcv_bufsize, 0, &saddr, &sizeaddr);
/* if recvfrom() is interrupted by screen update, an EINTR happens. */
      if (length < 0)
	{
	  /* I didn't want to do this... but non-blocking actually makes
	     this run... :(  
	     
	     Wow... ICMP calls see to come through HERE!!! when remote
	     This is super weird... the recvfrom is EAGAIN but
	     the data is meaningful!!! This appears to be the case
	     for all Linux kernels that I am running...
	     	version 1.2.13 and above...
	  */
	     
	  if (errno == EWOULDBLOCK) 
	  {
	      	handle_frame(buf,sn_rcv_bufsize,NULL);
	      	ethcnt++;
	      	cont = TRUE;
		continue;
	  }
 	  if (errno != EINTR)
	    {			/* if error detected and error is not expected type */
	      probcnt++;
	    }
	  else
	    {
	      intrcnt++;
	    }
	}
    }
  while (cont && errno == EINTR);
  if (length)
    {
      handle_frame (buf, length, &saddr);
    }
    else
  return (0);

}

int 
dokeyin ()
{
  int in_char;
  int dum;
  int ii;

  ESCON = 0;
  in_char = '\0';
  if ((in_char = getch ()) == ERR)
    return (0);
  if (in_char != 'q' && in_char != 'Q')
    {				/* while a 'q' was not typed */
/* This is the main data-gathering loop; keep it small and fast */
      if (localkey)
	ydisp = lydisp;
      else
	ydisp = rydisp;
      refreshgen = 0;
/* A key has been pressed; we fall out of main loop to process it. */
/* Wanted: A HELP screen should be added somehow. */
/* Wanted: Should show "q to quit" reminder if unknown keys are pressed. */
      switch (in_char)
	{
	case RETURNKEY:
	  if (help)
	    {
	      helppage++;
	      if (helppage > MAXHELPPAGE)
		helppage = 1;
	      setuphelp ();
	    }
	  break;
	case ESC:
	case KEY_F (10):
	case KEY_END:
	  if (watch || help)
	    {
	      if (selecthost)
		selectside = localkey;
	      watch = help = selecthost = magnafull = FALSE;
	      sn_rcv_bufsize = SN_RCV_BUF_SIZE;
	      disprouterstats = FALSE;
	      if (localkey)
		refreshrem = TRUE;
	      else
		refreshloc = TRUE;
	    }
	  break;
	case CONTROLL:
	  clrscr ();
	  if (watch)
	    setupwatch (SMALLSCREEN);
	  if (help)
	    setuphelp ();
	  rewrite_labels = TRUE;
	  refreshrem = TRUE;
	  refreshloc = TRUE;
	  break;
	case KEY_NPAGE:
	case KEY_DOWN:		/* DOWN KEY */
	  if (selecthost)
	    {
	      selectside = localkey;
	      selectchange = TRUE;
	      for (ii = 0; ii < MAGNAMAX; ii++)
		magna[ii].len = -1;
	      magnacnt = 0;
	      magnacomhost = NULL;
	      numselect++;
	      if (numselect >= (LINES - 5))
		{
		  ydisp += (LINES - 5);
		  refreshgen = TRUE;
		  numselect = 0;
		}

	    }
	  else
	    {
	      ydisp += (LINES - 5);
	      refreshgen = TRUE;
	    }
	  break;
	case KEY_LEFT:		/* LEFT KEY */
	  if (selecthost)
	    {
	      magnaoffs -= 10;
	      if (magnaoffs < 0)
		magnaoffs = 0;
	    }
	  else
	    {
	      dispopt--;
	      if (dispopt < 0)
		dispopt = DISP_MAX;
	      poschange = 1;
	      rewrite_labels = 1;
	    }
	  break;
	case KEY_PPAGE:
	case KEY_UP:		/* UP KEY */
	  if (selecthost)
	    {
	      selectside = localkey;
	      selectchange = TRUE;
	      for (ii = 0; ii < MAGNAMAX; ii++)
		magna[ii].len = -1;
	      magnacnt = 0;
	      magnacomhost = NULL;
	      numselect--;
	      if (numselect < 0)
		{
		  numselect = LINES - 6;
		  ydisp -= (LINES - 5);
		  if (ydisp < 0)
		    ydisp = 0;
		  refreshgen = TRUE;
		}
	    }
	  else
	    {
	      ydisp -= (LINES - 5);
	      if (ydisp < 0)
		ydisp = 0;
	      refreshgen = TRUE;
	    }
	  break;
	case KEY_RIGHT:	/* RIGHT KEY */
	  if (selecthost)
	    {
	      magnaoffs += 10;
	    }
	  else
	    {
	      dispopt++;
	      if (dispopt > DISP_MAX)
		dispopt = 0;
	      rewrite_labels = 1;
	      poschange = 1;
	    }
	  break;
	case KEY_F (1):
	case 'h':
	case 'H':
	  help = TRUE;
	  setuphelp ();
	  break;
	case KEY_F (4):
	case 'w':
	case 'W':
	  watch = TRUE;
	  disprouterstats = FALSE;
	  setupwatch (SMALLSCREEN);
	  break;
	case 'R':
	case 'r':
	  if (watch)
	    {
	      setupauxscr (&dum, SMALLSCREEN);
	      disprouterstats = TRUE;
	    }
	  break;
	case 'd':
	case 'D':
	  ignoredomain++;
	  ignoredomain &= 1;
	  break;
	case 'b':
	case 'B':
	  bluedie++;
	  bluedie &= 1;
	  break;

	case 'l':
	case 'L':
	  if ((statpid = fork ()) == 0)
	    {
	      /* In child process... to handle stats... */
	      gostats ();
	      exit ();

	    }
	  break;
	case '\t':		/* Switch from LOCAL to REMOTE sides of screen */
	  if (selecthost)
	    selectchange = TRUE;
	  localkey++;
	  localkey &= 1;
	  if (localkey)
	    ydisp = lydisp;
	  else
	    ydisp = rydisp;
	  if (watch)
	    {
	      setupwatch (SMALLSCREEN);
	    }
	  else if (help)
	    setuphelp ();
	  if (watch || help)
	    {
	      if (localkey)
		refreshrem = TRUE;
	      else
		refreshloc = TRUE;
	    }
	  break;
	case 'c':
	case 'C':
/* Clear Counters */
	  if (watch && disprouterstats)
	    {
	      maxburst = 0;
	      break;
	    }
	  current = lfirst->flink;
	  while (current != lfirst)
	    {
	      current->update = 2;
	      clearentry (current);
	      current = current->flink;
	    }
	  localupdate = 1;
	  current = rfirst->flink;
	  while (current != rfirst)
	    {
	      current->update = 2;
	      clearentry (current);
	      current = current->flink;
	    }
	  remoteupdate = 1;
	  break;
	case 'n':
	case 'N':
/* Start NEW.... Delete all entries...start again */
	  llockout = 1;
	  current = lfirst->flink;
	  lfirst->flink = lfirst;
	  lfirst->blink = lfirst;
	  while (current != lfirst)
	    {
	      work = current->flink;
	      free (current);
	      current = work;
	    }
	  llockout = 0;
	  rlockout = 1;
	  current = rfirst->flink;
	  rfirst->flink = rfirst;
	  rfirst->blink = rfirst;
	  while (current != rfirst)
	    {
	      work = current->flink;
	      free (current);
	      current = work;
	    }
	  rlockout = 0;
	  rewrite_labels = 1;
	  poschange = 1;
	  break;
	case 'q':
	case 'Q':
	  break;
	case ' ':
	  mvprintw (0, 60, "%c", ACS_BLOCK);
	  bugfix = TRUE;
	  break;
	case 's':		/*SELECT HOST in WATCH MODE */
	case 'S':
	  if (watch)
	    {
	      sn_rcv_bufsize = SN_RCV_BIGBUFSIZE;
	      selecthost = TRUE;
	    }
	  break;
	case 'z':		/*ZOOM for trace in WATCH MODE */
	case 'Z':
	  if (watch && selecthost)
	    {
	      magnafull++;
	      magnafull &= 1;
	      if (!magnafull)
		{
		  if (localkey)
		    refreshrem = TRUE;
		  else
		    refreshloc = TRUE;
		  setupwatch (SMALLSCREEN);
		}
	      else
		setupwatch (FULLSCREEN);
	    }
	  break;
	default:
	  mvprintw (0, 60, "%02x", in_char);
	  break;
	}
      if (magnafull)
	return (0);
      if (localkey)
	{
	  if (lydisp != ydisp)
	    refreshloc = refreshgen;
	  lydisp = ydisp;
	}
      else
	{
	  if (rydisp != ydisp)
	    refreshrem = refreshgen;
	  rydisp = ydisp;
	}
      return (0);
    }				/* while a 'q' was not typed */
  else
    return (-1);
}
