/*
  $Id: iname.h,v 1.6 1997/01/16 15:04:17 luik Exp $

  iname.h - inode/ompath to pathname conversion definitions for omirrd.
  Copyright (C) 1996-1997, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef INAME_H_INCLUDED
#define INAME_H_INCLUDED

#include <sys/types.h>

#ifdef	__cplusplus
extern "C" {
#endif

typedef enum InamStatus_ {
    INAM_SUCCESS = 0, INAM_NOTFOUND, INAM_INPROCESS, INAM_OTHERERROR
} InamStatus;


typedef struct DevIno_ {
    dev_t dev;
    ino_t ino;
} *DevIno, DevInoRec;


typedef void (*InamCallbackFunc)(DevIno dip, void *data);

typedef struct InamCallback_ {
    InamCallbackFunc callback;
    void *data;
} *InamCallback, InamCallbackRec;


typedef struct InamEntry_ *InamEntry;

typedef struct InamEntry_ {
    DevInoRec dev_ino;		/* dev/ino pair */
    char *pathname;		/* associated pathname (malloc'd) */
    unsigned int count;		/* reference count */
    time_t timestamp;		/* time created or last accessed */
    unsigned int state;		/* find running? (queue only) */
    int syserrno;		/* errno of find processing */
    InamEntry next;		/* ptr to next in linked list */
} InamEntryRec;

/* iname.c */
extern InamStatus inamAssocNameDevIno(char *pathname, DevIno di);
extern InamStatus inamLookupDevIno(DevIno dip, char **pathname);
extern void inamGarbageCollect(void);
extern InamStatus inamUseDevIno(DevIno di);
extern InamStatus inamFreeDevIno(DevIno di);
extern InamStatus inamRename(const char *name, const char *newname);
extern InamStatus inamRemove(const char *name);
extern InamStatus inamAddLookupDoneCallback(InamCallbackFunc func, void *data);
extern InamStatus inamRemoveLookupDoneCallback(InamCallbackFunc func, void *data);

#ifdef	__cplusplus
}
#endif

#endif /* defined(INAME_H_INCLUDED) */
