/*
 * PPPupd - parse.c - Parses Config file
 * Jake Bouvrie <swarthy@thetasys.com>
 * Fri Jan 26 03:32:07 EST 1996
 */

#include	"pppupd.h"

extern	int	level,
		facility;

OPT	*ParseConfigFile(void)
{
	char            aline[BUFSIZ];
        char            toksep[] = "\t :\n\0";
        char            *p, *fieldname;
	int		lineno = 0;
	FILE		*config = NULL;
	OPT		*options;

#ifdef _DEBUG_
	printf("Debug: Using %s for CONFIG_PATH\n", CONFIG_PATH);
#endif

	if ( (config = fopen(CONFIG_PATH, "r")) == NULL ) {
		perror(CONFIG_PATH);
		exit(1);
	}

	rewind(config);

	options = (OPT *)malloc(sizeof(OPT));

	while ((fgets(aline,BUFSIZ,config)) != NULL) {
		++lineno;
                if ((aline[0] == '#') || (aline[0] == '\n') || (aline[0] == '\0'
) || (aline[1] == '\n'))
                        continue;
		if ((fieldname = (char *)strtok(aline, toksep)) != NULL) {
 			if ((p = (char *)strtok(NULL, toksep)) != NULL) {

				fieldname = lowerstr(fieldname);

				if ( (strcmp(fieldname, "logpath")) == 0 ) {
					options->logpath = (char *)malloc(strlen(p) +1);
					strcpy(options->logpath, p);
				}
				else if ( (strcmp(fieldname, "connectscriptpath")) == 0 ) {
					options->connectscriptpath = (char *)malloc(strlen(p) +1);
					strcpy(options->connectscriptpath, p);
					exist(options->connectscriptpath);
				}
				else if ( (strcmp(fieldname, "killscriptpath")) == 0 ) {
                                        options->killscriptpath = (char *)malloc(strlen(p) +1);
                                        strcpy(options->killscriptpath, p);
					exist(options->killscriptpath);
                                }
				else if ( (strcmp(fieldname, "pingprogpath")) == 0 ) {
                                        options->pingpath = (char *)malloc(strlen(p) +1);
                                        strcpy(options->pingpath, p);
					exist(options->pingpath);
                                }
				else if ( (strcmp(fieldname, "pingaddr")) == 0) {
					options->pingaddr = (char *)malloc(strlen(p) +1);
					strcpy(options->pingaddr, p);
				}
				else if ( (strcmp(fieldname, "pidfilepath")) == 0) {
					options->pidpath = (char *)malloc(strlen(p) +1);
					strcpy(options->pidpath, p);
				}
				else if ( (strcmp(fieldname, "syslogpriority")) == 0) {
					options->syslogpriority = (char *)malloc(strlen(p) +1);
					strcpy(options->syslogpriority, p);
					makepriority(options->syslogpriority, &level, &facility);
				}
				else if ( (strcmp(fieldname, "sysloglogging")) == 0) {
					if ( (strcmp(p, "yes")) == 0)
						options->sysloglogging = 1;
					else
						options->sysloglogging = 0;
                                }
				else if ( (strcmp(fieldname, "checkdelay")) == 0 ) {
					options->delay = atoi(p);
				}
				else if ( (strcmp(fieldname, "daemonuid")) == 0 ) {
					options->uid = (uid_t)atoi(p);
				}
				else if ( (strcmp(fieldname, "daemongid")) == 0 ) {
					options->gid = (gid_t)atoi(p);
				}
				else if ( (strcmp(fieldname, "stdoutlogging")) == 0 ) {
					if ( (strcmp(p, "yes")) == 0)
						options->stdoutlogging = 1;
					else
						options->stdoutlogging = 0;
				}
				else {
					printf("Parse error (line %d): %s\n", lineno, fieldname);
				}
			}
		}
	}
	/* now check to make sure we have something for the essential opts */
	if (options == NULL) 
		err_fatal("Options was NULL. This is very bad.\n");
	if (options->logpath == NULL)
		err_fatal("No LogFilePath specified in config file!\n");
	if (options->connectscriptpath == NULL)
		err_fatal("No connect script specified!\n");
	if (options->killscriptpath == NULL)
		err_fatal("No KillConnection script path specified!\n");
	if (options->pingpath == NULL)
		err_fatal("No PingProgPath specified!\n");
	if (options->pingaddr == NULL)
		err_fatal("No PingAddr specified!\n");
	if (options->pidpath == NULL)
		err_fatal("No PidPath specified!\n");
	if (options-> delay == 0)
		err_fatal("Delay time is set to ZERO!\n");
	return options;
}
