/*
 * PPPupd - pppsubs.c - misc subroutines for PPPupd.
 * Jake Bouvrie <swarthy@thetasys.com>
 * Fri Jan 26 04:11:01 EST 1996
 */

#include	"pppupd.h"

extern	int	outlog;
extern	FILE	*logfile;

int	PPPConnect(OPT	*options)
{
	char	cmd[255];
	FILE	*foo = NULL;
	
	if (outlog) {
		system("date");
		fprintf(stderr, "Attempting to connect... \n");
	}
	fprintf(logfile , "Attempting to connect... \n");
	strcpy(cmd, options->connectscriptpath);
	strcat(cmd, " &");
	if (system(cmd)) {
		sleep(30);
		if ( (foo = fopen(options->logpath, "r")) != NULL ) {
			fclose(foo);
			if (outlog)
				fprintf(stderr, "Connection Reestablished\n");
			fprintf(logfile, "Connection Reestablished\n");
			return 0;
		}
		else {
			if (outlog)
                                fprintf(stderr, "Connection could NOT be Reestablished\n");
                        fprintf(logfile, "Connection could NOT be Reestablished\n");
                        return -1;
		}
	}
	else
		return -1;
}

int	PPPConnectTest(OPT	*options)
{
	struct hostent	*host = NULL;
	FILE		*foo = NULL;

	host = gethostbyname(options->pingaddr);
	if (host == NULL) {
		if (outlog)
			fprintf(stderr, "Lost Connection. [%s]", getdate());
		fprintf(logfile, "LostConnection. [%s]", getdate());
		return 1;
	}
	else
#ifdef _DEBUG_
		printf("Hostlookup worked\n");
		if ( logfile != NULL)
			fprintf(logfile, "Hostlookup worked\n");
		else
			printf("Arg! Log file is NULL!\n");
#endif
		if ((foo = fopen(options->pidpath, "r")) == NULL) {
			if (outlog)
				fprintf(stderr, "Lost Connection. [%s]", getdate());
			fprintf(logfile, "LostConnection. [%s]", getdate());
			return 1;
		}
		else
			fclose(foo);
		return 0; 
}

int	PPPSendPing(OPT	*options)
{
        int     pid, exitcode;
	pid_t	wait();
#ifdef _DEBUG_
        printf("******PING PATH: %s\n", options->pingpath);
#endif
        pid = fork();
        if (pid == 0) {
                execl(options->pingpath, "ping", "-c", "1", options->pingaddr, NULL);
                exit(-1);
        }
         signal(SIGINT, SIG_IGN);
         signal(SIGQUIT, SIG_IGN);
         while( wait( &exitcode ) != pid )
                ;
         signal( SIGINT, SIG_DFL );
         signal( SIGQUIT, SIG_DFL );
#ifdef _DEBUG_
        printf("*******EXIT CODE: %d\n", exitcode);
#endif
        if (exitcode != 0)  {
                if (outlog)
                        fprintf(stderr, "J00 ping failed! We lost connection. [%s]", getdate());
                fprintf(logfile, "J00 ping failed! We lost connection. [%s]", getdate());
                return 1;
        }
        else
                return 0;
}

int	PPPKill(char	*killscriptpath)
{
	char    cmd[255];

        strcpy(cmd, killscriptpath);
        strcat(cmd, " &");
        if (system(cmd)) {
		if (outlog) {
			system("date");
			fprintf(stderr, "Killed connection. [%s]", getdate());
		}
		fprintf(logfile,"Killed connection. [%s]", getdate());
		sleep(5);
                return 0;
	}
        else
                return -1;
}
