/* filename: rlpr-client.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlpr-client.h,v 1.2 1996/11/19 01:16:22 meem Exp meem $
 * contents: common routines and structures for the rlpr client
 *
 * Time-stamp: <1997/02/23 04:10 -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPR_CLIENT_H
#define RLPR_CLIENT_H

#include <sys/types.h>

/* environment variable names */
#define PRINTHOST         "RLPR_PRINTHOST"
#define PROXYHOST         "RLPR_PROXYHOST"
#define PROXYHOST2        "RLPR_PROXY"

enum rlpr_client_field {
  RLPR_CLIENT_PRINTER  , RLPR_CLIENT_PROXYHOST,
  RLPR_CLIENT_PRINTHOST, RLPR_CLIENT_LOCALHOST,
};

typedef struct rlpr_client_info {
  char *       localhost;            /* hostname of host rlpr is running on */
  char *       proxyhost;            /* hostname of proxy to go through     */
  char *       printhost;            /* hostname of printer to print to     */
  char *       printer;              /* the printer to print to             */
  u_short      dst_port;             /* port number to connect to (dst)     */
  u_short      src_port;             /* port number originatim from (src)   */
  int          no_bind:1;            /* don't do privileged bind            */
} rlpr_client_info;

void       rlpr_client_args(int argc, char * const argv[]);
void      rlpr_client_close(int sockfd);
int        rlpr_client_open(void);
void *      rlpr_client_get(enum rlpr_client_field field);

extern char * name;		     /* external program name */

#endif /* RLPR_CLIENT_H */

