/* filename: rlprd.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlprd.h,v 1.3 1996/12/20 18:12:16 meem Exp meem $
 * content: general definitions/declarations for rlprd.c
 *
 * Time-stamp: <1997/02/23 04:13 -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPRD_H
#define RLPRD_H

#include <sys/types.h>

typedef struct rlpr_rlprd_info {
  u_short   port;               /* port number to listen on */
  int       timeout;            /* how long before giving up on a client */
  int       daemon:1;           /* user requested daemon */
} rlpr_rlprd_info;

#define RLPRD_TIMEOUT  20       /* in seconds */

/* the default port the proxy (rlprd) listens on, that the client uses
 * to contact the proxy.  it can be anything you want as long as the
 * client and server are both in agreement.  note that putting it
 * below 1024 is asinine. 
 */

#define RLPRD_DST_PORT   7290   /* in host byte order */

/* exported functions */
int rlpr_rlprd_args(int argc, char *argv[]);
void    daemon_init(void); 

#endif /* RLPRD_H */
