/*================================================================
 * Tcl/Tk control program (for drvmidi pipe interface)
 *================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include "trace.h"
#include "config.h"
#include "util.h"
#include "midievent.h"
#include "channel.h"
#include "controls.h"
#include "ext_c.h"

#ifndef TKPROGPATH
#define TKPROGPATH "/usr/local/lib/tkawe/tkawe.tcl"
#endif

static int AppInit(Tcl_Interp *interp);
static int StartPlayer(ClientData clientData, Tcl_Interp *interp,
		       int argc, char *argv[]);
static int InitCmdLine(ClientData clientData, Tcl_Interp *interp,
		       int argc, char *argv[]);
static int ExitAll(ClientData clientData, Tcl_Interp *interp,
		       int argc, char *argv[]);

/*----------------------------------------------------------------*/


static int orig_argc;
static char **orig_argv;

void main(int argc, char **argv)
{
	int i, n_argc;
	char **n_argv;

	orig_argc = argc;
	orig_argv = argv;

	if ((n_argv = malloc(sizeof(char*) * (argc + 10))) == NULL) {
		fprintf(stderr, "can't malloc\n"); exit(1);
	}

	n_argc = 0;
	n_argv[n_argc++] = "-f";
	n_argv[n_argc++] = TKPROGPATH;
	for (i = 1; i < argc; i++)
		n_argv[n_argc++] = argv[i];

	Tk_Main(n_argc, n_argv, AppInit);
	exit(0);
}


Tcl_Interp *my_interp;

static int AppInit(Tcl_Interp *interp)
{
	my_interp = interp;

	if (Tcl_Init(interp) == TCL_ERROR)
		return TCL_ERROR;
	if (Tk_Init(interp) == TCL_ERROR)
		return TCL_ERROR;

	Tcl_CreateCommand(interp, "StartPlayer", StartPlayer,
			  (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
	Tcl_CreateCommand(interp, "ReallyQuit", ExitAll,
			  (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
	Tcl_CreateCommand(interp, "InitCmdLine", InitCmdLine,
			  (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
	Tcl_CreateCommand(interp, "TraceCreate", TraceCreate,
			  (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
	Tcl_CreateCommand(interp, "TraceUpdate", TraceUpdate,
			  (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
	Tcl_CreateCommand(interp, "TraceReset", TraceReset,
			  (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
	Tcl_CreateCommand(interp, "ExitAll", ExitAll,
			  (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);

	return TCL_OK;
}

/* start external drvmidi player via pipe control */
static int StartPlayer(ClientData clientData, Tcl_Interp *interp,
		       int argc, char *argv[])
{
	int i, j, n_argc;
	char **n_argv;

	n_argc = 1;
	for (i = 1; i < orig_argc; i++) {
		if (orig_argv[i][0] == '-' && orig_argv[i][1] == '-')
			n_argc++;
	}
	if ((n_argv = (char**)malloc(sizeof(char*) * n_argc)) == NULL) {
		fprintf(stderr, "can't malloc\n"); exit(1);
	}
	j = 0;
	for (i = 1; i < orig_argc; i++) {
		if (orig_argv[i][0] == '-' && orig_argv[i][1] == '-')
			n_argv[j++] = orig_argv[i];
	}
	n_argv[j++] = "--trace=on";
	ext_control_init(TRUE, TRUE, TRUE, TRUE, n_argc, n_argv);
	free(n_argv);
	return TCL_OK;
}

/* parse command line options and store midi file names */
static int InitCmdLine(ClientData clientData, Tcl_Interp *interp,
		       int argc, char *argv[])
{
	v_eval("ParseCmdLine");
	return TCL_OK;
}

/* kill child program and exit */
static int ExitAll(ClientData clientData, Tcl_Interp *interp,
		   int argc, char *argv[])
{
	ext_control_end();
	exit(0);
	return TCL_OK;
}

