;; $Id: dbadmon.dsl 1.1 1998/02/08 21:41:31 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================ ADMONITIONS =============================

(define ($admonition$)
  (make display-group
	space-before: %block-sep%
	space-after: %block-sep%
	(process-children)))

(define ($admonpara$)
  (let* ((title     (select-elements 
		     (children (parent (current-node))) "TITLE"))
	 (has-title (not (node-list-empty? title)))
	 (adm-title (if has-title 
			(make sequence
			  (with-mode xref-title-mode
			    (process-node-list (node-list-first title)))
			  (literal (gentext-label-title-sep 
				    (gi (parent (current-node))))))
			(literal
			 (gentext-element-name 
			  (gi (parent (current-node))))
			 (gentext-label-title-sep 
			  (gi (parent (current-node))))))))
    (make paragraph
      space-before: %para-sep%
      space-after: %para-sep%
      font-size: (- %bf-size% 1pt)
      font-weight: 'medium
      font-posture: 'upright
      font-family-name: %admon-font-family%
      line-spacing: (* (- %bf-size% 1pt) %line-spacing-factor%)
      start-indent: (+ (inherited-start-indent) (* (ILSTEP) 2))
      (if (= (child-number) 1)
	  (make sequence
	    font-family-name: %title-font-family%
	    font-weight: 'bold
	    adm-title)
	  (empty-sosofo))
      (process-children))))

(element IMPORTANT ($admonition$))
(element (IMPORTANT TITLE) (empty-sosofo))
(element (IMPORTANT PARA) ($admonpara$))
(element (IMPORTANT SIMPARA) ($admonpara$))
(element NOTE ($admonition$))
(element (NOTE TITLE) (empty-sosofo))
(element (NOTE PARA) ($admonpara$))
(element (NOTE SIMPARA) ($admonpara$))
(element TIP ($admonition$))
(element (TIP TITLE) (empty-sosofo))
(element (TIP PARA) ($admonpara$))
(element (TIP SIMPARA) ($admonpara$))

;; perils are given special treatment by generating a centered title
;;   and throwing a box around them
;; note that the paragraph indents are set by the box characteristics
;;
(define ($peril$)
  (let* ((title     (select-elements 
		     (children (current-node)) "TITLE"))
	 (has-title (not (node-list-empty? title)))
	 (adm-title (if has-title 
			(make sequence
			  (with-mode xref-title-mode
			    (process-node-list (node-list-first title))))
			(literal
			 (gentext-element-name 
			  (gi (current-node))))))
	 (hs (HSIZE 2)))
    (make display-group
      space-before: %block-sep%
      space-after: %block-sep%
      (make box
	display?: #t
	box-type: 'border
	line-thickness: 2pt
	start-indent: (+ (inherited-start-indent) (* 2 (ILSTEP)) 2pt)
	end-indent: (inherited-end-indent)
	(make paragraph
	  space-before: %para-sep%
	  space-after: %para-sep%
	  start-indent: 1em
	  end-indent: 1em
	  font-family-name: %title-font-family%
	  font-weight: 'bold
	  font-size: hs
	  line-spacing: (* hs %line-spacing-factor%)
	  quadding: 'center
	  keep-with-next?: #t
	  adm-title)
	(process-children)))))

(element CAUTION ($peril$))
(element (CAUTION TITLE) (empty-sosofo))
(element WARNING ($peril$))
(element (WARNING TITLE) (empty-sosofo))

