/* Ruari Diff, a program to compare a Packages file and /var/lib/dpkg/status */
/* Copyright (C) 1997, James Troup <jjtroup@comp.brad.ac.uk> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <string.h>
#include <db.h>
#include "common.h"
#include "error.h"
#include "xmalloc.h"
#include "hash.h"
#include "main.h"

HASHINFO *m68k_hash_info;
DB *m68k_table = NULL;
DBT *package_dbt, *key;
int key_length;
char package_key[PACKAGE_NAME_LENGTH];

void
create_hash_table(void)
{

  m68k_hash_info = xmalloc (sizeof(*m68k_hash_info));

  m68k_hash_info->bsize = 256;
  m68k_hash_info->cachesize = 1048576;
  m68k_hash_info->ffactor = 8;
  m68k_hash_info->hash = NULL; /* I checked the default hash
			        * functions, they are much better than
			        * any of my efforts and showed no
			        * collisions with a normal Packages
			        * file (March 15th, 1997)
			        */
  m68k_hash_info->lorder = 0;
  m68k_hash_info->nelem = 1;

  m68k_table = dbopen (NULL, O_RDWR, 0, DB_HASH, m68k_hash_info);

  if (m68k_table == NULL)
    error (FATAL | SYSERR, "Unable to create the hash table");

  package_dbt = xmalloc (sizeof(*package_dbt));
  package_dbt->size = sizeof (struct package_info);

  key = xmalloc (sizeof(*key));
  key->data = package_key;

}

void 
add_to_hash_table (const char *package, const char *version, 
		   const char *priority, const char *section)
{

  struct package_info package_to_hash;
  int i;

  strncpy (package_to_hash.package_name, package, PACKAGE_STR_LENGTH);
  strncpy (package_to_hash.version, version, VERSION_STR_LENGTH);
  strncpy (package_to_hash.priority, priority, PRIORTY_STR_LENGTH);
  strncpy (package_to_hash.section, section, SECTION_STR_LENGTH);

  package_dbt->data = &package_to_hash;

  strcpy ( package_key, package );
  key->size = strlen (package);

/*   fprintf (stderr, "package = \"%s\", version = %s, priority: %s, section: %s\n", package_to_hash.package_name, package_to_hash.version,  */
/* 	  package_to_hash.priority, package_to_hash.section); */
/*   fprintf (stderr, "package_dbt = %lx, package_dbt size = %d\n", package_dbt->data, package_dbt->size); */
/*   fprintf (stderr, "Key data = \"%s\", key size = %d\n", key->data, key->size); */
/*   fprintf (stderr, "Adding \"%s\" (%s:%s) [Version %s] to hash table\n", package, section, priority, version); */

  i = m68k_table->put (m68k_table, key, package_dbt, R_NOOVERWRITE);

  if (i == 1)
    {
      if (warn_duplicates)
	fprintf (stderr, "Warning: %s is already in the hash table, skipping duplicate in Packages file\n", package);
    }
  else if (i != 0)
    error (FATAL, "couldn't add \"%s\" to hash table", package);

}

struct package_info
*get_from_hash_table (const char *package)
{

  struct package_info *package_details;

  strcpy ( package_key, package );
  key->size = strlen (package);

  /* RQ: WTF do I do with flags?  Presently set to 0. */

  if (m68k_table->get (m68k_table, key, package_dbt, 0) != 0)
    package_details = NULL;
  else
    package_details = (struct package_info *) package_dbt->data;

  return (package_details);  
}

void
destroy_hash_table(void)
{

 if (m68k_table == NULL)
    error (FATAL, "No hash table to destroy!");
  
 if (m68k_table->close(m68k_table))
   error (FATAL | SYSERR, "Couldn't destroy hash table");

  free (key);
  free (package_dbt);
  free (m68k_hash_info);

}

