/* -*-Mode: C;-*-
 * XDELTA - RCS replacement and delta generator
 * Copyright (C) 1997  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: misc.c 1.3 Sun, 12 Oct 1997 20:29:34 -0700 jmacd $
 */

#include "xdelta.h"
#include <unistd.h>
#include <time.h>
#include "maketime.h"
#include "md5.h"

/* Misc stuff from PRCS src code. */

gchar*
time_t_to_rfc822(time_t t)
{
  /* Thanks to Paul Eggert for this. */
  static char timebuf[64];
  static const char day[7][4] =
  { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
  static const char mon[12][4] =
  { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
  struct tm lt = *localtime(&t);
  int utc_offset = difftm(&lt, gmtime(&t));
  char sign = utc_offset < 0 ? '-' : '+';
  int minutes = abs(utc_offset) / 60;
  int hours = minutes / 60;
  sprintf(timebuf, "%s, %02d %s %d %02d:%02d:%02d %c%02d%02d",
	  day[lt.tm_wday], lt.tm_mday, mon[lt.tm_mon], lt.tm_year + 1900,
	  lt.tm_hour, lt.tm_min, lt.tm_sec,
	  sign, hours, minutes % 60);
  return timebuf;
}

gboolean
fs_file_exists(gchar* P)
{
  return access(P, F_OK) >= 0;
}


gchar*
strip_leading_path (gchar* p)
{
  gchar* ls = strrchr (p, '/');

  if (ls)
    return ls + 1;

  return p;
}

time_t get_utc_time_t()
{
    static time_t t = 0;

    if(t)
	return t;

    time(&t);

    return t;
}

void
md5_buffer(gchar* buffer, gint buflen, gchar* digest)
{
  MD5_CTX context;

  MD5Init(&context);
  MD5Update(&context, (unsigned char*)buffer, buflen);
  MD5Final(digest, &context);
}
