#ifndef ___ARENA_FORMS_I_H___
#  define ___ARENA_FORMS_I_H___

/* Header file for "forms.c" internal use.
 * Public declarations can be found in "forms.h".
 */

#include "display_types.h"
#include "forms.h"


typedef struct { int x ; int y ; } ArenaXPoint;
typedef struct { int number ; Option* option ; } NumberedOption;
typedef enum { keyPROCESS_SUCCESS,	/* state of the doc has changed */
	       keyPROCESS_SWALLOW,	/* state of the doc hasn't changed */
	       keySUBMIT_FORM,		/* the key requests form submission */
	       keyPROCESS_NOACTION,	/* no action bind to the key at all */
	       keyPROCESS_FAILED } KeyProcessFeedback;

ArenaXPoint FieldCursorRelativeXPoint(Field* field, int font);

Bool PaintTextField(GC gc, ViewWindow view_window,
		    int indent, int baseline, Bool active, Field* field);

Bool PaintDropDown(GC gc, ViewWindow view_window,
		   int indent, Field* field);
Bool  HideDropDown(GC gc, ViewWindow view_window,
		   Doc* doc, int indent, Field* field);
Bool PaintSelectField(GC gc, ViewWindow view_window,
		      int indent, int baseline,
		      Bool theFieldIsActive, Field* field);

Bool PaintRadioButton(GC gc, ViewWindow view_window,
		      int indent, int baseline,
		      Bool theFieldIsActive, Field* field);
Bool PaintRadioButtonGroup(GC gc, ViewWindow view_window, Field* field);
Bool SetRadioButton(Field* field);

Bool PaintCheckboxField(GC gc, ViewWindow view_window,
			int indent, int baseline,
			Bool theFieldIsActive, Field* field);

Bool PaintButtonField(GC gc, ViewWindow view_window,
		      int indent, int baseline,
		      Bool theFieldIsActive, Field* field);

Bool PaintForm(GC gc, ViewWindow view_window, Form* form);


#endif	/* ifndef ___ARENA_FORMS_I_H___ */
