/*
**	SWISH++
**	util.h
**
**	Copyright (C) 1998  Paul J. Lucas
**
**	This program is free software; you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation; either version 2 of the License, or
**	(at your option) any later version.
** 
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
** 
**	You should have received a copy of the GNU General Public License
**	along with this program; if not, write to the Free Software
**	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef	util_H
#define	util_H

// standard
#include <cctype>
#include <cstring>

// local
#include "config.h"

inline bool	is_word_char( char c ) {
			return c > 0 && !!std::strchr( Word_Chars, tolower(c) );
		}

extern bool	is_ok_word( char const *word );

		// ensure function semantics, i.e, that 'c' is expanded once
inline char	to_lower( char c )		{ return tolower( c ); }
inline char	to_upper( char c )		{ return toupper( c ); }

extern char const *ltoa( long );
inline char const *itoa( int    n )		{ return ::ltoa( n ); }
inline char const *ntoa( short  n )		{ return ::ltoa( n ); }
inline char const *ntoa( int    n )		{ return ::ltoa( n ); }
inline char const *ntoa( long   n )		{ return ::ltoa( n ); }

#endif	/* util_H */
