/* workspace.c- Workspace management
 * 
 *  WindowMaker window manager
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef WMWORKSPACE_H_
#define WMWORKSPACE_H_



typedef struct WWorkspace {
    char *name;
#ifdef DOCK
    struct WDock *fiend;
#endif
#ifdef PAGER
    struct WPagerView *view;
#endif
} WWorkspace;

void wWorkspaceMake(WScreen *scr, int count);
int wWorkspaceNew(WScreen *scr);
void wWorkspaceDeleteLast(WScreen *scr);
void wWorkspaceChange(WScreen *scr, int workspace);

WMenu *wWorkspaceMenuMake(WScreen *scr);
void wWorkspaceMenuUpdate(WScreen *scr, WMenu *menu);

void wWorkspaceMenuEdit(WScreen *scr);

void wWorkspaceSaveState(WScreen *scr);
void wWorkspaceRestoreState(WScreen *scr);


#endif
