/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1997
 *  Jamie Zawinski <jwz@netscape.com>
 *
 * This file describes the keymap of a "MITSUMI KPQ-E99YC" 101 key
 * AT/XT switchable PC-style keyboard under Linux with XFree86 2.0.
 * This differs from the keyboard we know as `pc101' in the placement
 * of the "\ and |" key.
 * Generated by Gord Vreugdenhil <gvreugde@plg.uwaterloo.ca>
 *
 * Modified by Poonlap Veeratanabutr <poon-v@fedu.uec.ac.jp>
 * Map Thai Kedmanee keyboard on US keyboard layout.
 * 27 May 1997
 */

#ifndef XK_XF86ModeLock
# define XK_XF86ModeLock 0x1008FF01
#endif

static struct default_keycode_map linux101_2th_map [] = {
  {   9, 0,		{ XK_Escape }},
  {  10, 0,		{ XK_1, XK_exclam,	XK_aring, XK_plus }},
  {  11, 0,		{ XK_2, XK_at,		XK_slash, XK_ntilde }},
  {  12, 0,		{ XK_3, XK_numbersign,	XK_underscore, XK_ograve }},
  {  13, 0,		{ XK_4, XK_dollar,	XK_Agrave, XK_oacute }},
  {  14, 0,		{ XK_5, XK_percent,	XK_paragraph, XK_ocircumflex}},
  {  15, 0,		{ XK_6, XK_asciicircum,	XK_Ooblique, XK_Ugrave }},
  {  16, 0,		{ XK_7, XK_ampersand,	XK_Odiaeresis, XK_ssharp }},
  {  17, 0,		{ XK_8, XK_asterisk,	XK_currency, XK_otilde }},
  {  18, 0,		{ XK_9, XK_parenleft,	XK_mu, XK_odiaeresis }},
  {  19, 0,		{ XK_0, XK_parenright,	XK_diaeresis, XK_division }},
  {  20, 0,		{ XK_minus, XK_underscore,	XK_cent, XK_oslash }},
  {  21, 0,		{ XK_equal, XK_plus,	XK_ordfeminine, XK_ugrave }},
  {  22, 0,		{ XK_BackSpace }},
  {  23, 0,		{ XK_Tab }},
  {  24, 0,		{ XK_q, XK_Q,	XK_ae, XK_eth }},
  {  25, 0,		{ XK_w, XK_W,	XK_adiaeresis, XK_quotedbl }},
  {  26, 0,		{ XK_e, XK_E,	XK_Oacute, XK_registered }},
  {  27, 0,		{ XK_r, XK_R,	XK_threequarters, XK_plusminus }},
  {  28, 0,		{ XK_t, XK_T,	XK_ETH, XK_cedilla }},
  {  29, 0,		{ XK_y, XK_Y,	XK_Ntilde, XK_iacute }},
  {  30, 0,		{ XK_u, XK_U,	XK_Otilde, XK_ecircumflex }},
  {  31, 0,		{ XK_i, XK_I,	XK_Atilde, XK_threesuperior }},
  {  32, 0,		{ XK_o, XK_O,	XK_onesuperior, XK_Idiaeresis }},
  {  33, 0,		{ XK_p, XK_P,	XK_Acircumflex, XK_hyphen }},
  {  34, 0,		{ XK_bracketleft, XK_braceleft,	
			  XK_masculine, XK_degree }},
  {  35, 0,		{ XK_bracketright, XK_braceright,
			  XK_Aring, XK_comma }},
  {  36, 0,		{ XK_Return }},
  {  37, ControlMask,	{ XK_Control_L }},
  {  38, 0,		{ XK_a, XK_A,	XK_questiondown, XK_Adiaeresis }},
  {  39, 0,		{ XK_s, XK_S,	XK_Ediaeresis, XK_brokenbar }},
  {  40, 0,		{ XK_d, XK_D,	XK_exclamdown, XK_macron }},
  {  41, 0,		{ XK_f, XK_F,	XK_acute, XK_acircumflex }},
  {  42, 0,		{ XK_g, XK_G,	XK_agrave, XK_notsign }},
  {  43, 0,		{ XK_h, XK_H,	XK_eacute, XK_ccedilla }},
  {  44, 0,		{ XK_j, XK_J,	XK_egrave, XK_ediaeresis }},
  {  45, 0,		{ XK_k, XK_K,	XK_Ograve, XK_Eacute }},
  {  46, 0,		{ XK_l, XK_L,	XK_Ecircumflex, XK_Egrave }},
  {  47, 0,		{ XK_semicolon, XK_colon,
			  XK_Ccedilla, XK_guillemotleft }},
  {  48, 0,		{ XK_apostrophe, XK_quotedbl,
			  XK_section, XK_period }},
  {  49, 0,		{ XK_grave, XK_asciitilde,
			  XK_minus, XK_percent }},
  {  50, ShiftMask,	{ XK_Shift_L }},
  {  51, 0,		{ XK_backslash, XK_bar,	XK_sterling, XK_yen }},
  {  52, 0,		{ XK_z, XK_Z,	XK_onequarter, XK_parenleft }},
  {  53, 0,		{ XK_x, XK_X,	XK_guillemotright, XK_parenright }},
  {  54, 0,		{ XK_c, XK_C,	XK_aacute, XK_copyright }},
  {  55, 0,		{ XK_v, XK_V,	XK_Iacute, XK_Icircumflex }},
  {  56, 0,		{ XK_b, XK_B,	XK_Ocircumflex, XK_Uacute }},
  {  57, 0,		{ XK_n, XK_N,	XK_multiply, XK_igrave }},
  {  58, 0,		{ XK_m, XK_M,	XK_periodcentered, XK_question }},
  {  59, 0,		{ XK_comma, XK_less,
			  XK_Aacute, XK_twosuperior }},
  {  60, 0,		{ XK_period, XK_greater,
			  XK_atilde, XK_Igrave }},
  {  61, 0,		{ XK_slash, XK_question,	XK_onehalf, XK_AE }},
  {  62, ShiftMask,	{ XK_Shift_R }},
  {  63, 0,		{ XK_KP_Multiply }},
  {  64, Mod1Mask,	{ XK_Alt_L, XK_Meta_L }},
  {  65, 0,		{ XK_space }},
  {  66, LockMask,	{ XK_Caps_Lock }},
  {  67, 0,		{ XK_F1 }},
  {  68, 0,		{ XK_F2 }},
  {  69, 0,		{ XK_F3 }},
  {  70, 0,		{ XK_F4 }},
  {  71, 0,		{ XK_F5 }},
  {  72, 0,		{ XK_F6 }},
  {  73, 0,		{ XK_F7 }},
  {  74, 0,		{ XK_F8 }},
  {  75, 0,		{ XK_F9 }},
  {  76, 0,		{ XK_F10 }},
  {  77, 0,		{ XK_Num_Lock }},
  {  78, Mod2Mask,	{ XK_Mode_switch, XK_XF86ModeLock }},
  {  79, 0,		{ XK_KP_7 }},
  {  80, 0,		{ XK_KP_8 }},
  {  81, 0,		{ XK_KP_9 }},
  {  82, 0,		{ XK_KP_Subtract }},
  {  83, 0,		{ XK_KP_4 }},
  {  84, 0,		{ XK_KP_5 }},
  {  85, 0,		{ XK_KP_6 }},
  {  86, 0,		{ XK_KP_Add }},
  {  87, 0,		{ XK_KP_1 }},
  {  88, 0,		{ XK_KP_2 }},
  {  89, 0,		{ XK_KP_3 }},
  {  90, 0,		{ XK_KP_0 }},
  {  91, 0,		{ XK_KP_Decimal }},
  {  94, 0,		{ XK_less, XK_greater }},
  {  95, 0,		{ XK_F11 }},
  {  96, 0,		{ XK_F12 }},
  {  97, 0,		{ XK_Home }},
  {  98, 0,		{ XK_Up }},
  {  99, 0,		{ XK_Prior }},
  { 100, 0,		{ XK_Left }},
  { 101, 0,		{ XK_Begin }},
  { 102, 0,		{ XK_Right }},
  { 103, 0,		{ XK_End }},
  { 104, 0,		{ XK_Down }},
  { 105, 0,		{ XK_Next }},
  { 106, 0,		{ XK_Insert }},
  { 107, 0,		{ XK_Delete }},
  { 108, 0,		{ XK_KP_Enter }},
  { 109, ControlMask,	{ XK_Control_R }},
  { 110, 0,		{ XK_Pause }},
  { 111, 0,		{ XK_Print }},
  { 112, 0,		{ XK_KP_Divide }},
  { 113, Mod1Mask,	{ XK_Alt_R, XK_Meta_R }},
  { 114, 0,		{ XK_Break }}
  };
