;;; 
;;; tm-partial.el --- Grabbing all MIME "message/partial"s.
;;; 
;;; Copyright (C) 1995 Free Software Foundation, Inc.
;;; Copyright (C) 1994 OKABE Yasuo
;;; Copyright (C) 1995 MORIOKA Tomohiko
;;;
;;; Author: OKABE Yasuo @ Kyoto University
;;;         MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;; Version:
;;;	$Id: tm-partial.el,v 7.11 1995/11/16 15:51:10 morioka Exp $ 
;;; Keywords: mail, news, MIME, multimedia, message/partial
;;;
;;; This file is a part of tm (Tools for MIME).
;;;

(require 'tm-view)
(require 'tm-play)

(defvar tm-partial/preview-article-method-alist nil)
   
;; display Article at the cursor in Subject buffer.
(defun tm-partial/preview-article (target)
  (let ((f (assq target tm-partial/preview-article-method-alist)))
    (if f
	(funcall (cdr f))
      (error "Fatal. Unsupported mode")
      )))

(defun mime-article/grab-message/partials (beg end cal)
  (interactive)
  (let* ((id (cdr (assoc "id" cal)))
	 (buffer (generate-new-buffer id))
	 (mother mime::article/preview-buffer)
	 (target (cdr (assq 'major-mode cal)))
	 (article-buffer (buffer-name (current-buffer)))
	 (subject-buf (eval (cdr (assq 'summary-buffer-exp cal))))
	 subject-id
	 (root-dir (expand-file-name
		    (concat "m-prts-" (user-login-name)) mime/tmp-dir))
	 full-file)
    (setq root-dir (concat root-dir "/" (replace-as-filename id)))
    (setq full-file (concat root-dir "/FULL"))
    
    (if (null target)
	(error "%s is not supported. Sorry." target)
      )
    
    ;; if you can't parse the subject line, try simple decoding method
    (if (or (file-exists-p full-file)
	    (not (y-or-n-p "Merge partials?"))
	    )
	(progn
	  (kill-buffer buffer)
	  (mime-article/decode-message/partial beg end cal)
	  )
      (let (cinfo the-id parameters)
	(setq subject-id (rfc822/get-field-body "Subject"))
	(if (string-match "[0-9\n]+" subject-id)
	    (setq subject-id (substring subject-id 0 (match-beginning 0)))
	  )
	(pop-to-buffer subject-buf)
	(while (search-backward subject-id nil t)
	  )
	(catch 'tag
	  (while t
	    (tm-partial/preview-article target)
	    (pop-to-buffer article-buffer)
	    (switch-to-buffer mime::article/preview-buffer)
	    (setq cinfo
		  (mime::preview-content-info/content-info
		   (car mime::preview/content-list)))
	    (setq parameters (mime::content-info/parameters cinfo))
	    (setq the-id (assoc-value "id" parameters))
	    (if (equal the-id id)
		(progn
		  (switch-to-buffer article-buffer)
		  (mime-article/decode-message/partial
		   (point-min)(point-max) parameters)
		  (if (file-exists-p full-file)
		      (throw 'tag nil)
		    )
		  ))
	    (if (not (progn
		       (pop-to-buffer subject-buf)
		       (end-of-line)
		       (search-forward subject-id nil t)
		       ))
		(error "not found")
	      )
	    ))))))


;;; @ end
;;;

(provide 'tm-partial)

(run-hooks 'tm-partial-load-hook)
