/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.layout;

import com.jtauber.fop.layout.Area;
import com.jtauber.fop.layout.FontState;
import com.jtauber.fop.layout.LineArea;
import com.jtauber.fop.render.Renderer;

public class BlockArea
extends Area {
    protected int startIndent;
    protected int endIndent;
    protected int textIndent;
    protected int lineHeight;
    protected int halfLeading;
    protected int align;
    protected int alignLastLine;
    protected LineArea currentLineArea;
    protected boolean hasLines = false;

    public BlockArea(FontState fontState, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(fontState, n, n2);
        this.startIndent = n3;
        this.endIndent = n4;
        this.textIndent = n5;
        this.contentRectangleWidth = n - n3 - n4;
        this.align = n6;
        this.alignLastLine = n7;
        this.lineHeight = n8;
        this.halfLeading = (n8 - fontState.getFontSize()) / 2;
    }

    public void addLineArea(LineArea lineArea) {
        if (!lineArea.isEmpty()) {
            this.addDisplaySpace(this.halfLeading);
            int n = lineArea.getHeight();
            this.addChild(lineArea);
            this.increaseHeight(n);
            this.addDisplaySpace(this.halfLeading);
        }
    }

    public int addText(FontState fontState, float f, float f2, float f3, int n, int n2, char[] cArray, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        char[] cArray2 = cArray;
        if (this.currentHeight + this.currentLineArea.getHeight() > this.maxHeight) {
            return n3;
        }
        this.currentLineArea.changeFont(fontState);
        this.currentLineArea.changeColor(f, f2, f3);
        this.currentLineArea.changeWrapOption(n);
        this.currentLineArea.changeWhiteSpaceTreatment(n2);
        n5 = this.currentLineArea.addText(cArray2, n5, n6);
        this.hasLines = true;
        while (n5 != -1) {
            this.currentLineArea.align(this.align);
            this.addLineArea(this.currentLineArea);
            this.currentLineArea = new LineArea(fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent, this.endIndent);
            if (this.currentHeight + this.currentLineArea.getHeight() > this.maxHeight) {
                return n5;
            }
            this.currentLineArea.changeFont(fontState);
            this.currentLineArea.changeColor(f, f2, f3);
            this.currentLineArea.changeWrapOption(n);
            this.currentLineArea.changeWhiteSpaceTreatment(n2);
            n5 = this.currentLineArea.addText(cArray2, n5, n6);
        }
        return -1;
    }

    public void end() {
        if (this.hasLines) {
            this.currentLineArea.addPending();
            this.currentLineArea.align(this.alignLastLine);
            this.addLineArea(this.currentLineArea);
        }
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public void render(Renderer renderer) {
        renderer.renderBlockArea(this);
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
        this.currentLineArea = new LineArea(this.fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent + this.textIndent, this.endIndent);
    }
}

