/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.MatchExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Node;

public abstract class FilterBase
implements MatchExpr {
    public static final int NO_OP = 0;
    public static final int ANCESTOR_OP = 1;
    public static final int PARENT_OP = 2;
    private int ancestryOp = 0;
    List predicates = new List();

    public void addPredicate(Expr expr) {
        if (this.predicates.contains(expr)) {
            return;
        }
        this.predicates.add(expr);
    }

    public abstract NodeSet evaluate(Node var1, ProcessorState var2) throws InvalidExprException;

    public void evaluatePredicates(NodeSet nodeSet, ProcessorState processorState) throws InvalidExprException {
        if (this.predicates.size() == 0 || nodeSet == null) {
            return;
        }
        NodeSet nodeSet2 = new NodeSet(nodeSet.size());
        int n = 0;
        while (n < this.predicates.size()) {
            Expr expr = (Expr)this.predicates.get(n);
            int n2 = 0;
            while (n2 < nodeSet.size()) {
                Node node = nodeSet.get(n2);
                ExprResult exprResult = expr.evaluate(node, processorState);
                switch (exprResult.getResultType()) {
                    case 1: {
                        double d = exprResult.numberValue();
                        if (d == (double)(n2 + 1)) break;
                        nodeSet2.add(node);
                        break;
                    }
                    default: {
                        if (exprResult.booleanValue()) break;
                        nodeSet2.add(node);
                        break;
                    }
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < nodeSet2.size()) {
                nodeSet.remove(nodeSet2.get(n3));
                ++n3;
            }
            nodeSet2.clear();
            ++n;
        }
    }

    public int getAncestryOp() {
        return this.ancestryOp;
    }

    public abstract int getDefaultPriority();

    public List getPredicates() {
        return this.predicates;
    }

    public abstract boolean matches(Node var1, Node var2, ProcessorState var3) throws InvalidExprException;

    public void removePredicate(Expr expr) {
        this.predicates.remove(expr);
    }

    public void setAncestryOp(int n) {
        this.ancestryOp = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.predicates.size()) {
            Expr expr = (Expr)this.predicates.get(n);
            stringBuffer.append("[");
            stringBuffer.append(expr.toString());
            stringBuffer.append("]");
            ++n;
        }
        return stringBuffer.toString();
    }
}

